package db;

import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.tweak.HandleCallback;
import pojo.model.DBMetaColumn;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by feeling on 18/1/18.
 */
public class HBaseDBInstance {
    private DBI dbi;
    public HBaseDBInstance(DBI dbi) {
        this.dbi = dbi;
    }

    public List<String> dbTables() {
        return dbi.withHandle(new HandleCallback<List<String>>() {
            public List<String> withHandle(Handle handle) throws Exception {
                List<String> res = new ArrayList<String>();
                Connection connection = handle.getConnection();
                ResultSet resultSet = connection.getMetaData().getTables(
                        connection.getCatalog(), null, null, new String[]{"TABLE"}
                );
                while (resultSet.next()) {
                    res.add("DATA." + resultSet.getString("TABLE_NAME"));
                }
                resultSet.close();
                return res;
            }
        });
    }

    public List<DBMetaColumn> tableColumns(String tableName) {
        return dbi.withHandle(new HandleCallback<List<DBMetaColumn>>() {
            @Override
            public List<DBMetaColumn> withHandle(Handle handle) throws Exception {
                List<DBMetaColumn> res = new ArrayList<>();
                Connection connection = handle.getConnection();

                ResultSet resultSet = connection.getMetaData().getColumns(
                        connection.getCatalog(), null, tableName.toUpperCase().replace("DATA.", ""), ""
                );
                while (resultSet.next()) {
                    res.add(new DBMetaColumn(resultSet.getString(4), resultSet.getInt(5)));
                }
                resultSet.close();
                return res;
            }
        });
    }

}
