package db;

import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import org.skife.jdbi.v2.sqlobject.stringtemplate.ExternalizedSqlViaStringTemplate3;
import org.skife.jdbi.v2.sqlobject.stringtemplate.UseStringTemplate3StatementLocator;
import org.skife.jdbi.v2.unstable.BindIn;
import pojo.mapper.MarsUserMapper;
import pojo.model.MarsUser;

import java.util.List;

/**
 * Created by feeling on 17/12/22.
 */
@UseStringTemplate3StatementLocator
public interface MarsUserDAO {
    @SqlQuery("select id as user_id, username" +
            " from auth_user" +
            " where id in (select user_id from api_userextra where login_mars = 1)")
    @RegisterMapper(MarsUserMapper.class)
    List<MarsUser> getAllUsers();

    @SqlQuery("select id as user_id, username" +
            " from auth_user" +
            " where id in (<user_ids>)")
    @RegisterMapper(MarsUserMapper.class)
    List<MarsUser> getUsersByUserIds(@BindIn("user_ids") List<Object> userIds);


}
