package db;

import org.skife.jdbi.v2.sqlobject.*;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import pojo.mapper.TemplateDataInfoMapper;
import pojo.mapper.TemplateMapper;
import pojo.model.*;

import java.util.Collection;
import java.util.List;

/**
 * Created by feeling on 17/12/22.
 */
public interface TemplateDAO {

    @SqlQuery("select * from monitor_template")
    @RegisterMapper(TemplateMapper.class)
    List<Template> getAll();


    @SqlQuery("select * from monitor_template where id =:id")
    @RegisterMapper(TemplateMapper.class)
    Template getTemplateById(@Bind("id") Integer id);


    @SqlQuery("select t1.id, t1.template_id,t1.metadata_id, name, source, source_table, filters, groups, aggregate_function, is_delete" +
            " from monitor_template_data t1 left join monitor_metadata t2" +
            " on t1.metadata_id = t2.id " +
            " where t1.template_id =:id and t2.is_delete = 0")
    @RegisterMapper(TemplateDataInfoMapper.class)
    List<TemplateDataInfo> getTemplateDataInfoById(@Bind("id") Integer id);


    @SqlUpdate("insert ignore into monitor_template (name, template_type, report_type, cron_time, created_time) values (:name, :template_type, :report_type, :cron_time, :created_time)")
    @GetGeneratedKeys
    Integer addTemplate(@Bind("name") String name, @Bind("template_type") Integer templateType, @Bind("report_type") Integer reportType, @Bind("cron_time") String cronTime, @Bind("created_time") String createdTime);

    @SqlUpdate("update monitor_template set name =:name, template_type =:template_type, report_type =:report_type, cron_time =:cron_time where id =:id")
    void  updateTemplate(@Bind("id") Integer id, @Bind("name") String name, @Bind("template_type") Integer templateType, @Bind("report_type") Integer reportType, @Bind("cron_time") String cronTime);

    @SqlBatch("insert ignore into monitor_template_data (`template_id`, `metadata_id`) values (:templateId, :metadataId)")
    int[] addMetaData(@BindBean Collection<TemplateData> templateDatas);

    @SqlUpdate("delete from monitor_template_data where template_id =:id")
    void deleteMetaData(@Bind("id") Integer id);
}
