package pojo.mapper;

import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import pojo.model.CustomMetaData;

import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * Created by feeling on 17/12/21.
 */
public class CustomMetaDataMapper implements ResultSetMapper<CustomMetaData> {
    public static CustomMetaDataMapper FIRST = new CustomMetaDataMapper();

    public CustomMetaData map(int i, ResultSet resultSet, StatementContext statementContext) throws SQLException {
        return new CustomMetaData(
                resultSet.getInt("id"),
                resultSet.getString("name"),
                resultSet.getString("column_name"),
                resultSet.getString("source"),
                resultSet.getString("source_table"),
                resultSet.getString("filters"),
                resultSet.getString("groups"),
                resultSet.getString("aggregate_function"),
                resultSet.getInt("is_delete")
        );
    }
}
