package pojo.mapper;

import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import pojo.model.TemplateDataInfo;

import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * Created by feeling on 17/12/21.
 */
public class TemplateDataInfoMapper implements ResultSetMapper<TemplateDataInfo> {
    public static TemplateDataInfoMapper FIRST = new TemplateDataInfoMapper();

    public TemplateDataInfo map(int i, ResultSet resultSet, StatementContext statementContext) throws SQLException{
        return new TemplateDataInfo(
                resultSet.getInt("id"), resultSet.getInt("template_id"),
                resultSet.getInt("metadata_id"), resultSet.getString("name"),
                resultSet.getString("source"), resultSet.getString("source_table"),
                resultSet.getString("filters"),
                resultSet.getString("groups"),
                resultSet.getString("aggregate_function"),
                resultSet.getInt("is_delete")
        );
    }
}
