package pojo.mapper;

import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.sqlobject.customizers.Mapper;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import pojo.model.TemplateResult;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

/**
 * Created by feeling on 17/12/21.
 */
public class TemplateResultMapper implements ResultSetMapper<TemplateResult> {
    public static final TemplateResultMapper FIRST = new TemplateResultMapper();

    public TemplateResult map(int i, ResultSet resultSet, StatementContext statementContext) throws SQLException{
        return new TemplateResult(
                resultSet.getInt("id"),
                resultSet.getInt("template_id"),
                resultSet.getString("result_json"),
                resultSet.getString("created_time")
        );
    }
}
