package pojo.model;

import com.cloudera.org.codehaus.jackson.annotate.JsonCreator;
import com.cloudera.org.codehaus.jackson.map.ObjectMapper;
import utils.BaseModel;

import java.io.IOException;
import java.util.List;

/**
 * Created by feeling on 17/12/15.
 */
public class Template extends BaseModel {

    private Integer id;
    private String name;
    private Integer templateType;
    private Integer reportType;
    private String cronTime;
    private List<TemplateUser> templateUsers;
    private List<String> templateString;
    private List<TemplateData> templateDatas;
    private TemplateCustomSql templateCustomSql;

    @JsonCreator
    public Template() {}

    public Template(Integer id, String name, Integer templateType, Integer reportType, String cronTime) {
        this.id = id;
        this.name = name;
        this.templateType = templateType;
        this.reportType = reportType;
        this.cronTime = cronTime;
//        if (resultJson != null && !"".equals(resultJson)) {
//            this.resultJson = resultJson;
//        }
    }

    public String getName() {return this.name;}
    public Integer getId() {return this.id;}
    public Integer getTemplateType() {return this.templateType;}
    public Integer getReportType() {return this.reportType;}
    public String getCronTime() {return this.cronTime;}
    public List<String> getTemplateString() {return this.templateString;}


    public List<TemplateUser> getTemplateUsers() {
        return templateUsers;
    }

    public List<TemplateData> getTemplateDatas() {
        return templateDatas;
    }

    public TemplateCustomSql getTemplateCustomSql() {
        return templateCustomSql;
    }
    //    public String getResultJson() {return this.resultJson;}


    public void setId(Integer id) {
        this.id = id;
        if (templateDatas != null) {
            for(TemplateData templateData: templateDatas) {
                templateData.setTemplateId(id);
            }
        }

        if (templateCustomSql != null) {
            templateCustomSql.setTemplateId(this.id);
        }

        if (templateUsers != null) {
            for (TemplateUser templateUser: templateUsers) {
                templateUser.setTemplateId(this.id);
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTemplateType(Integer templateType) {
        this.templateType = templateType;
    }

    public void setReportType(Integer reportType) {
        this.reportType = reportType;
    }

    public void setCronTime(String cronTime) {
        this.cronTime = cronTime;
    }

    public void setTemplateUsers(List<TemplateUser> templateUsers) {
        this.templateUsers = templateUsers;
    }

    public void setTemplateString(List<String> templateString) {
        this.templateString = templateString;
    }

    public void setTemplateDatas(List<TemplateData> templateDatas) {
        this.templateDatas = templateDatas;
    }

    public void setTemplateCustomSql(TemplateCustomSql templateCustomSql) {
        this.templateCustomSql = templateCustomSql;
    }
}
