package pojo.response;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by feeling on 17/12/19.
 */
public class TemplateResponse {
    @JsonProperty("msg")
    private String msg;
    @JsonProperty("status")
    private Integer status;
    @JsonProperty("data")
    private TemplateData templateData;

    public TemplateResponse() {
        this.msg = "";
        this.status = 0;
        this.templateData = new TemplateData();
    }

    public TemplateResponse(String msg, Integer status) {
        this.msg = msg;
        this.status = status;
    }

    public void addItem(Integer id, String name, int templateType, int reportType, String cronTime, String resultJson) {
        this.templateData.addItem(id, name, templateType, reportType, cronTime, resultJson);
    }

    private class TemplateData {
        @JsonProperty("templateData")
        private List<TemplateItem> data;

        public TemplateData() {
            this.data = new ArrayList<>();
        }

        public void addItem(Integer id, String name, int templateType, int reportType, String cronTime, String resultJson) {
            this.data.add(new TemplateItem(id, name, templateType, reportType, cronTime, resultJson));
        }
        private class TemplateItem

        {
            @JsonProperty("id")
            private int id;
            @JsonProperty("name")
            private String name;
            @JsonProperty("template_type")
            private int templateType;
            @JsonProperty("report_type")
            private int reportType;
            @JsonProperty("cron_time")
            private String cronTime;
            @JsonProperty("job_status")
            private Integer jobStatus;

            public TemplateItem(Integer id, String name, int templateType, int reportType, String cronTime, String resultJson) {
                this.id = id;
                this.name = name;
                this.templateType = templateType;
                this.reportType = reportType;
                this.cronTime = cronTime;
                if (resultJson != null && !"".equals(resultJson)) {
                    this.jobStatus = 1;
                }
                else {
                    this.jobStatus = 0;
                }

            }
        }
    }
}
