package resources;

/**
 * Created by feeling on 17/12/7.
 */
import core.Saying;
import com.google.common.base.Optional;
import com.codahale.metrics.annotation.Timed;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import pojo.response.CustomMataDataResponse;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;

@Path("/hello-world")
@Produces(MediaType.APPLICATION_JSON)
public class HelloWorldResource {
    private final String template;
    private final String defaultName;
    private final AtomicLong counter;

    public HelloWorldResource(String template, String defaultName) {
        this.template = template;
        this.defaultName = defaultName;
        this.counter = new AtomicLong();
    }

    @Path("/get")
    @GET
    @Timed
    public Saying sayHello(@QueryParam("name") Optional<String> name) {
        final String value = String.format(template, name.or(defaultName));
        return new Saying(counter.incrementAndGet(), value);
    }

    @Path("/test")
    @GET
    @Timed
    public String testApi(@QueryParam("name") Optional<String> name) {

        try {
            URL url = new URL("https://www.baidu.com");
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
            for (String line; (line = reader.readLine()) != null;) {
                System.out.println(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "TeSt" + name.toString();
    }

    @Path("/test_meta")
    @GET
    @Timed
    public CustomMataDataResponse testMeta() {
        HashMap hashMap = new HashMap();

        ArrayList arrayList = new ArrayList();
        ArrayList arrayList1 = new ArrayList();
        for (int i=0; i < 5; i++) {
            arrayList.add(i);
            HashMap item = new HashMap();
            item.put("id", i);
            item.put("name", "name_"+ i);
            arrayList1.add(item);
        }
        hashMap.put("list", arrayList);
        hashMap.put("list1", arrayList1);
        System.out.println(hashMap);
        return new CustomMataDataResponse(hashMap);
    }
}