package resources;

import com.cloudera.org.codehaus.jackson.map.ObjectMapper;
import com.codahale.metrics.annotation.Timed;
import db.*;
import javassist.expr.Cast;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.util.StringMapper;

import javax.swing.text.html.parser.Entity;
import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import java.io.IOException;
import java.util.*;

import pojo.mapper.*;
import pojo.model.*;
import pojo.response.CommonResponse;
import pojo.response.TemplateResponse;

/**
 * Created by feeling on 17/12/15.
 */


@Path("/template")
@Produces(MediaType.APPLICATION_JSON)
@Consumes(MediaType.APPLICATION_JSON)
public class TemplateResource {

    private HashMap<String, DBI> dbiHashMap;
    private CommonResponse commonResponse;

    public TemplateResource(HashMap<String, DBI> dbiHashMap) {
        this.dbiHashMap = dbiHashMap;
    }


    @Path("/list")
    @GET
    @Timed
    public TemplateResponse getTemplateList() {
        TemplateDAO templateDAO = DAOManager.INSTANCE.getDAO(TemplateDAO.class);
        List<Template> ids = templateDAO.getAll();

        TemplateResultDAO templateResultDAO = DAOManager.INSTANCE.getDAO(TemplateResultDAO.class);
        List<TemplateResult> templateResults = templateResultDAO.getTemplateResultByTime(DateTime.now().toString("yyyy-MM-dd"));

        HashMap<Integer, TemplateResult> resultMap = new HashMap<Integer, TemplateResult>();
        for(TemplateResult templateResult: templateResults) {
            resultMap.put(templateResult.getTemplateId(), templateResult);
        }
        TemplateResponse res = new TemplateResponse();
        for(Template map: ids) {
            TemplateResult result = resultMap.get(map.getId());
            String resultJson = "";
            if(result != null) {
                resultJson = result.getResultJson();
            }
            res.addItem(
                    map.getId(), map.getName(), map.getTemplateType(), map.getReportType(), map.getCronTime(), resultJson
            );
        }
        return res;
    }


    @Path("/info")
    @GET
    @Timed
    public CommonResponse getTemplateInfo(@QueryParam("id") Integer id) throws Exception {
        if (id <= 0) {
            throw new Exception("bad id");
        }

        TemplateDAO templateDAO = DAOManager.INSTANCE.getDAO(TemplateDAO.class);
        Template template = templateDAO.getTemplateById(id);
        HashMap<String, Object> data = template.getData();

        TemplateUserDAO templateUserDAO = DAOManager.INSTANCE.getDAO(TemplateUserDAO.class);
        List<TemplateUser> templateUsers = templateUserDAO.getUserByTemplateId(id);
        List<HashMap<String, Object>> userList = new ArrayList<>();
        List<Object> users = new ArrayList<>();
        for(TemplateUser templateUser: templateUsers) {
            HashMap<String, Object> templateData = templateUser.getData();
            users.add(templateData.getOrDefault("mars_user_id", 0));
        }
        for (MarsUser marsUser: this.getTemplateUsers(users)) {
            userList.add(marsUser.getData());
        }
        data.put("user_list", userList);

        if (data.get("template_type").toString().equals('0')) {
            List<HashMap<String, Object>> dataList = new ArrayList<>();
            for(TemplateDataInfo templateDataInfo: templateDAO.getTemplateDataInfoById(id)) {
                dataList.add(templateDataInfo.getData());
            }
            data.put("metadata_list", dataList);
        }
        else {
            TemplateCustomSqlDAO templateCustomSqlDAO = DAOManager.INSTANCE.getDAO(TemplateCustomSqlDAO.class);
            TemplateCustomSql templateCustomSql = templateCustomSqlDAO.getTemplateSqlById(id);
            if (templateCustomSql != null) {
                data.put("template_sql", templateCustomSql.getData());
            }
            else {
                data.put("template_sql", new HashMap());
            }
        }

        return new CommonResponse(data);
    }

    private List<MarsUser> getAllMarsUsers() {
        MarsUserDAO marsUserDAO = DAOManager.INSTANCE.getDAO(MarsUserDAO.class);
        List<MarsUser> marsUsers = marsUserDAO.getAllUsers();
        return marsUsers;
    }

    private List<MarsUser> getTemplateUsers(List<Object> userList) {
        System.out.println(userList);
        MarsUserDAO marsUserDAO = DAOManager.INSTANCE.getDAO(MarsUserDAO.class);
        List<MarsUser> marsUsers = marsUserDAO.getUsersByUserIds(userList);
        return marsUsers;
    }


    @Path("/metadata_list")
    @GET
    @Timed
    public CommonResponse getMetaDataList(){
        CustomMetaDataDAO customMetaDataDAO = DAOManager.INSTANCE.getDAO(CustomMetaDataDAO.class);
        List<CustomMetaData> customMetaDatas = customMetaDataDAO.getAll(0);
        List<HashMap<String, Object>> listData = new ArrayList<HashMap<String, Object>>();
        for(CustomMetaData customMetaData: customMetaDatas) {
            listData.add(customMetaData.getData());
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("metadata_list", listData);
        return new CommonResponse(data);
    }


    @Path("/metadata_info")
    @GET
    @Timed
    public CommonResponse getMetaDataInfo(@QueryParam("id") Integer id) {
        CustomMetaDataDAO customMetaDataDAO = DAOManager.INSTANCE.getDAO(CustomMetaDataDAO.class);
        CustomMetaData customMetaData = customMetaDataDAO.getDataById(id, 0);
        return new CommonResponse(customMetaData.getData());
    }


    @Path("/edit_template")
    @POST
    @Timed
    public CommonResponse editTemplate(Template template) throws IOException {
        System.out.println(template.getId() + "\t" + template.getName() + "\t" + template.getReportType() + "\t" + template.getTemplateType() + "\t" + template.getCronTime());
        TemplateDAO templateDAO = DAOManager.INSTANCE.getDAO(TemplateDAO.class);
        Integer templateId;
        if (template.getId() == null) {
            templateId = templateDAO.addTemplate(template.getName(), template.getTemplateType(), template.getReportType(), template.getCronTime(), DateTime.now().toString("yyyy-MM-dd HH:mm:ss"));
            template.setId(templateId);
        }
        else {
            templateId = template.getId();
            templateDAO.updateTemplate(template.getId(), template.getName(), template.getTemplateType(), template.getReportType(), template.getCronTime());
        }


        if (template.getTemplateUsers() != null) {
            TemplateUserDAO templateUserDAO = DAOManager.INSTANCE.getDAO(TemplateUserDAO.class);
            templateUserDAO.deleteUsers(templateId);
            templateUserDAO.addUser(template.getTemplateUsers());
        }

        if (template.getTemplateDatas() != null) {
            templateDAO.deleteMetaData(templateId);
            templateDAO.addMetaData(template.getTemplateDatas());
        }

        if (template.getTemplateCustomSql() != null) {
            TemplateCustomSqlDAO templateCustomSqlDAO = DAOManager.INSTANCE.getDAO(TemplateCustomSqlDAO.class);
            templateCustomSqlDAO.upateTemplateCustomSql(templateId, template.getTemplateCustomSql().getSource(), template.getTemplateCustomSql().getSqlText());
        }

        return new CommonResponse();
    }


    @Path("/edit_metadata")
    @POST
    @Timed
    public CommonResponse editMetadata(CustomMetaData customMetaData) {
        CustomMetaDataDAO customMetaDataDAO = DAOManager.INSTANCE.getDAO(CustomMetaDataDAO.class);
        if (customMetaData.getId() != null) {
            customMetaDataDAO.updateMetaData(customMetaData.getId(), customMetaData.getName(), customMetaData.getColumnName(), customMetaData.getSource(), customMetaData.getSourceTable(), customMetaData.getFilters(), customMetaData.getGroups(), customMetaData.getAggregateFunction());
        }
        else {
            customMetaDataDAO.insertMetaData(customMetaData.getName(), customMetaData.getColumnName(), customMetaData.getSource(), customMetaData.getSourceTable(), customMetaData.getFilters(), customMetaData.getGroups(), customMetaData.getAggregateFunction());
        }
        return new CommonResponse();
    }



}