package utils;

/**
 * Created by feeling on 17/12/21.
 */
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class DBInstanceManager {
    final public static DBInstanceManager INSTANCE = new DBInstanceManager();

    private ConcurrentHashMap<String, DBInstance> dbInstances;

    public DBInstanceManager() {
        this.dbInstances = new ConcurrentHashMap<>();
    }

    public void registerDBInstance(String dbName, DBInstance instance){
        this.dbInstances.put(dbName, instance);
    }

    public DBInstance getInstance(String dbName){
        return this.dbInstances.get(dbName);
    }

    public ConcurrentHashMap<String, DBInstance> getDbInstances() {
        return dbInstances;
    }
}
