package utils;


import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * Created by feeling on 17/12/26.
 */
public class JsonUtil {

    public static ObjectMapper mapper = new ObjectMapper();


    public static List json2MapList(String jsonStr) throws IOException{
        List<HashMap<String, Object>> dataLists = new ArrayList<HashMap<String, Object>>();
        if (jsonStr.length() > 0) {
            dataLists = mapper.readValue(jsonStr, new TypeReference<List<HashMap<String, Object>>>(){});
        }
        return dataLists;
    }

    public static List json2List(String jsonStr) throws IOException {
        List dataLists = new ArrayList<>();
        if (jsonStr.length() > 0) {
            dataLists = mapper.readValue(jsonStr, new TypeReference<List>() {
            });
        }
        return dataLists;
    }

    public static HashMap<String, Object> json2Map(String jsonStr) throws IOException {
        HashMap<String, Object> dataLists = new HashMap<String, Object>();
        if (jsonStr.length() > 0) {
            dataLists = mapper.readValue(jsonStr, new TypeReference<HashMap<String, Object>>() {
            });
        }
        return dataLists;
    }
}
