package db;

/**
 * Created by feeling on 17/12/22.
 * Copy from Databus
 */
import org.skife.jdbi.v2.DBI;

import java.util.concurrent.ConcurrentHashMap;

public class DAOManager {

    public static DAOManager INSTANCE = new DAOManager();

    private ConcurrentHashMap<Class, Object> internalMap;

    public DAOManager() {
        this.internalMap = new ConcurrentHashMap<>();
    }

    public  <T> T getDAO(Class T){
        if(!this.internalMap.containsKey(T)){
            throw new RuntimeException(String.format("not found dao: %s , in DAOManager", T.getName()));
        }
        T obj = (T)this.internalMap.get(T);
        return obj;
    }

    public void addDAO(Class T, DBI dbi){
        if(this.internalMap.containsKey(T)){
            return;
        }
        if(T.isInterface()){
            this.internalMap.put(T, dbi.onDemand(T));
        }else {
            try{
                this.internalMap.put(T, T.getConstructor(DBI.class).newInstance(dbi));
            }catch (Exception e){
                e.printStackTrace();
            }
        }
    }

}
