package db;

import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.tweak.HandleCallback;
import pojo.model.DBMetaColumn;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by feeling on 18/1/18.
 */
public class HiveDBInstance {
    private DBI dbi;
    public HiveDBInstance(DBI dbi) {
        this.dbi = dbi;
    }

    public List<String> dbTables() {
        return dbi.withHandle(new HandleCallback<List<String>>() {
            public List<String> withHandle(Handle handle) throws Exception {
                List<String> res = new ArrayList<String>();
                Connection connection = handle.getConnection();
                ResultSet resultSet = connection.getMetaData().getTables(
                        connection.getCatalog(), null, null, new String[]{"TABLE"}
                );
                while (resultSet.next()) {
                    res.add(resultSet.getString("TABLE_NAME"));
                }
                resultSet.close();
                return res;
            }
        });
    }

    public List<DBMetaColumn> tableColumns(String tableName) {
        return dbi.withHandle(new HandleCallback<List<DBMetaColumn>>() {
            @Override
            public List<DBMetaColumn> withHandle(Handle handle) throws Exception {
                List<DBMetaColumn> res = new ArrayList<>();
                Connection connection = handle.getConnection();
                ResultSet resultSet = connection.prepareStatement("describe "+tableName).executeQuery();
                ResultSetMetaData metaData = resultSet.getMetaData();
                while (resultSet.next()) {
                    String columnName = resultSet.getString(metaData.getColumnName(1));
                    String columnType = resultSet.getString(metaData.getColumnName(2));
                    if (!columnName.startsWith("#") && !columnName.isEmpty() && !columnName.equals("")) {
                        res.add(new DBMetaColumn(columnName, columnType));
                    }
                }
                resultSet.close();
                return res;
            }
        });
    }
}
