package db;

import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import pojo.mapper.HiveMetaTblMapper;
import pojo.model.HiveMetaTbl;

import java.util.List;

/**
 * Created by feeling on 17/12/28.
 */
public interface HiveMetaTblDAO {

    @SqlQuery("select TBL_ID, tbls.DB_ID as DB_ID, `NAME` AS DB_NAME, tbls.SD_ID, TBL_NAME, TBL_TYPE, sds.CD_ID as CD_ID" +
            " from (select DB_ID, `NAME` from dbs where `NAME`=:dbName) db join tbls on db.DB_ID = tbls.DB_ID" +
            " join sds on tbls.SD_ID = sds.SD_ID")
    @RegisterMapper(HiveMetaTblMapper.class)
    List<HiveMetaTbl> getTbls(@Bind("dbName") String dbName);
}
