package db;

import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.deser.std.NumberDeserializers;
import org.apache.kylin.jdbc.shaded.com.google.protobuf.Int32Value;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import pojo.mapper.TemplateCustomSqlMapper;
import pojo.model.TemplateCustomSql;

/**
 * Created by feeling on 17/12/22.
 */
public interface TemplateCustomSqlDAO {
    @SqlQuery("select id, template_id, source, sql_text" +
            " from monitor_template_sql" +
            " where template_id =:id")
    @RegisterMapper(TemplateCustomSqlMapper.class)
    TemplateCustomSql getTemplateSqlById(@Bind("id")Integer id);

    @SqlUpdate("replace into monitor_template_sql (template_id, source, sql_text) values (:template_id, :source, :sql_text)")
    void upateTemplateCustomSql(@Bind("template_id") Integer templateId, @Bind("source") String source, @Bind("sql_text") String sqlText);
}
