package db;

import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import org.skife.jdbi.v2.util.StringMapper;
import pojo.mapper.TemplateResultMapper;
import pojo.model.TemplateResult;

import java.util.List;

/**
 * Created by feeling on 17/12/22.
 */
public interface TemplateResultDAO {
    @SqlQuery("select id, template_id, result_json, created_time from monitor_template_result where created_time=:created_time group by template_id order by id desc")
    @RegisterMapper(TemplateResultMapper.class)
    List<TemplateResult> getTemplateResultByTime(@Bind("created_time") String createdTime);


    @SqlQuery("select id, template_id, result_json, created_time from monitor_template_result where template_id =:id")
    @RegisterMapper(TemplateResultMapper.class)
    TemplateResult getTemplateResultById(@Bind("id") Integer id);

    @SqlUpdate("insert ignore into monitor_template_result (template_id, result_json, created_time) values (:template_id, :result_json, :created_time)")
    void addTemplateResult(@Bind("template_id") Integer templateId, @Bind("result_json") String resultJson, @Bind("created_time")String createdTime);
}
