package db;

import org.skife.jdbi.v2.sqlobject.*;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import pojo.mapper.MarsUserMapper;
import pojo.mapper.TemplateUserMapper;
import pojo.model.MarsUser;
import pojo.model.TemplateUser;

import java.util.Collection;
import java.util.List;

/**
 * Created by feeling on 17/12/22.
 */
public interface TemplateUserDAO {

    @SqlQuery("select * from monitor_template_user where template_id =:id")
    @RegisterMapper(TemplateUserMapper.class)
    List<TemplateUser> getUserByTemplateId(@Bind("id") Integer id);

    @SqlBatch("insert ignore into monitor_template_user (`template_id`, `mars_user_id`) values (:templateId, :marsUserId)")
    int[] addUser(@BindBean Collection<TemplateUser> templateUsers);

    @SqlUpdate("delete from monitor_template_user where template_id=:template_id")
    void deleteUsers(@Bind("template_id") Integer templateId);
}
