package pojo.model;

import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.core.JsonGenerationException;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.json.simple.JSONObject;
import utils.BaseModel;
import utils.JsonUtil;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * Created by feeling on 17/12/21.
 */
public class CustomMetaData extends BaseModel{
    private Integer id;
    private String name;
    private String columnName;
    private String source;
    private String sourceTable;
    private String filters;
    private String groups;
    private String aggregateFunction;
    private Integer isDelete;
    private List<HashMap<String, Object>> filterLists;
//    final private String tableName = "monitor_metadata";

    public CustomMetaData(){}

    public CustomMetaData(Integer id, String name, String columnName, String source, String sourceTable, String filters, String groups, String aggregateFunction, Integer isDelete) {
        this.id = id;
        this.name = name;
        this.columnName = columnName;
        this.source = source;
        this.sourceTable = sourceTable;
        this.filters = filters;
        this.groups = groups;
        this.aggregateFunction = aggregateFunction;
        this.isDelete = isDelete;
    }

    public Integer getId() {
        return id;
    }

    public String getColumnName() {
        return columnName;
    }

    public String getName() {
        return name;
    }

    public String getSource() {
        return source;
    }

    public String getSourceTable() {
        return sourceTable;
    }

    public String getFilters() {
        return filters;
    }

    public String getGroups() {
        return groups;
    }

    public String getAggregateFunction() {
        return aggregateFunction;
    }

    public Integer getIsDelete() {
        return isDelete;
    }

    public List<HashMap<String, Object>> getMapFilters() throws IOException{
        return JsonUtil.json2MapList(filters);
    }

    public List getListGroups() throws IOException{
        return JsonUtil.json2List(groups);
    }
}
