package resources;

import com.codahale.metrics.annotation.Timed;
import db.HBaseDBInstance;
import org.skife.jdbi.v2.DBI;
import pojo.model.DBMetaColumn;
import pojo.response.CommonResponse;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * Created by feeling on 18/1/18.
 */
@Path("/hbase")
@Produces(MediaType.APPLICATION_JSON)
@Consumes(MediaType.APPLICATION_JSON)
public class HBaseMetastoreResource {

    private  HashMap<String, DBI> dbiHashMap;
    private HBaseDBInstance hBaseDBInstance;
    public HBaseMetastoreResource(HashMap<String, DBI> dbiHashMap) {
        this.dbiHashMap = dbiHashMap;
        try {
            hBaseDBInstance = new HBaseDBInstance(dbiHashMap.get("hbase"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Path("/tbl_list")
    @GET
    @Timed
    public CommonResponse getTableList() {
        List<String> data = hBaseDBInstance.dbTables();
        return new CommonResponse(new HashMap(){{put("tblList", data);}});
    }

    @Path("/column_list")
    @GET
    @Timed
    public CommonResponse getColumnList(@QueryParam("name") String name) {
        List<DBMetaColumn> dataList = hBaseDBInstance.tableColumns(name);
        List<HashMap<String, String>> res = new ArrayList<>();
        for(DBMetaColumn data : dataList) {
            res.add(new HashMap(){
                {
                    put("name",data.getFieldName());
                    put("type",data.getFieldType());
                }
            });
        }
        return new CommonResponse(new HashMap(){{put("tblList", res);}});
    }

}
