package resources;

import com.codahale.metrics.annotation.Timed;
import db.DAOManager;
import db.HiveDBInstance;
import db.HiveMetaColumnDAO;
import db.HiveMetaTblDAO;
import org.skife.jdbi.v2.DBI;
import pojo.model.DBMetaColumn;
import pojo.model.HiveMetaColumn;
import pojo.model.HiveMetaTbl;
import pojo.response.CommonResponse;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * Created by feeling on 17/12/28.
 */
@Path("/hive")
@Produces(MediaType.APPLICATION_JSON)
@Consumes(MediaType.APPLICATION_JSON)
public class HiveMetastoreResource {
    private HashMap<String, DBI> dbiHashMap;
    private CommonResponse commonResponse;
    private HiveDBInstance hiveDBInstance;

    public HiveMetastoreResource(HashMap<String, DBI> dbiHashMap) {
        this.dbiHashMap = dbiHashMap;
        hiveDBInstance = new HiveDBInstance(dbiHashMap.get("hive"));
    }

    @Path("/tbl_list")
    @GET
    @Timed
    public CommonResponse getAllHiveMetaTbls() {
        HiveMetaTblDAO hiveMetaTblsDAO = DAOManager.INSTANCE.getDAO(HiveMetaTblDAO.class);
        String dbName = "online";
        List<HashMap> data = new ArrayList<HashMap>();
        List<HiveMetaTbl> hiveMetaTbls = hiveMetaTblsDAO.getTbls(dbName);
        for (HiveMetaTbl hiveMetaTbl: hiveMetaTbls) {
            data.add(hiveMetaTbl.getData());
        }
        return new CommonResponse(new HashMap(){{put("tblList", data);}});
    }


    @Path("/column_list")
    @GET
    @Timed
    public CommonResponse getTblColumnList(@QueryParam("cd_id") Integer cdId) {
        HiveMetaColumnDAO hiveMetaColumnDAO = DAOManager.INSTANCE.getDAO(HiveMetaColumnDAO.class);
        List<HashMap> data = new ArrayList<HashMap>();
        List<HiveMetaColumn> hiveMetaColumns = hiveMetaColumnDAO.getAllColumns(cdId);
        for (HiveMetaColumn hiveMetaColumn: hiveMetaColumns) {
            data.add(hiveMetaColumn.getData());
        }
        return new CommonResponse(new HashMap(){{put("columnList", data);}});
    }


    @Path("/tbl_list_v1")
    @GET
    @Timed
    public CommonResponse test(){
        HiveDBInstance hiveDBInstance = new HiveDBInstance(dbiHashMap.get("hive"));
        List<String> data=  hiveDBInstance.dbTables();
        return new CommonResponse(new HashMap(){{put("tblList", data);}});
    }

    @Path("/column_list_v1")
    @GET
    @Timed
    public CommonResponse getColumnList(@QueryParam("name") String name) {
        List<DBMetaColumn> dataList = hiveDBInstance.tableColumns(name);
        List<HashMap<String, String>> res = new ArrayList<>();
        for(DBMetaColumn data : dataList) {
            res.add(new HashMap(){
                {
                    put("name",data.getFieldName());
                    put("type",data.getFieldType());
                }
            });
        }
        return new CommonResponse(new HashMap(){{put("columnList", res);}});
    }
}
