package utils;

import com.cloudera.org.codehaus.jackson.map.ObjectMapper;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;

/**
 * Created by feeling on 17/12/21.
 */
public class BaseModel {

    public HashMap<String, Object> getData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        Field[] fields = this.getObjFields();
        try {
            for (int i = 0; i < fields.length; i++) {
                Field f = fields[i];
                f.setAccessible(true);
                data.put(f.getName(), f.get(this));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return data;
    }

    private Field[] getObjFields(){
        return this.getClass().getDeclaredFields();
    }

    private String transformString(String str) {
        if (str.length() <= 0) {
            return str;
        }
        String transformString = "";
        for (int i=0 ; i < str.length(); i++) {
            Character tmpChar = str.charAt(i);
            if (Character.isUpperCase(tmpChar)) {
                transformString += "_"+ tmpChar.toString().toLowerCase();
            }
            else {
                transformString += tmpChar.toString().toLowerCase();
            }
        }
        return transformString;
    }


}
