/*
 * @author lsy
 * @date   2019-11-05
 **/
import 'dart:math';
import 'dart:ui';

import 'package:example_flutter/commonModel/toast/toast.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';

import 'Annotations/RouterCenterRestore.mark.dart';
import 'commonModel/live/BaseModel.dart';
import 'commonModel/live/LiveData.dart';

class HomeItem {
  HomeItem(this.index, this.svgIcon, this.name);

  int index;
  String svgIcon;
  String name;
}

class HomeModel extends BaseModel {
  LiveData<int> widgetLive = new LiveData();
  final List<HomeItem> items = [];
  final List<Widget> pages = [];
  int currentIndex = 0;

  @override
  void dispose() {
    widgetLive.dispost();
  }

  void init() {
    var mainWidget = RouterCenterImpl().findHomeRouter()?.getHomePage();
    var persionPage = RouterCenterImpl().findUserRouter()?.getPersionPage();
    var checkPage = RouterCenterImpl().findHomeRouter()?.getCheckPage();
    var findPage = RouterCenterImpl().findHomeRouter()?.getDataPage();
    int index = 0;
    if (mainWidget != null) {
      items.add(HomeItem(index, "images/home.svg", "主页"));
      pages.add(mainWidget);
      index++;
    }
    if (checkPage != null) {
      items.add(HomeItem(index, "images/home.svg", "主页"));
      pages.add(checkPage);
      index++;
    }
    if (persionPage != null) {
      items.add(HomeItem(index, "images/home.svg", "主页"));
      pages.add(persionPage);
      index++;
    }
    if (findPage != null) {
      items.add(HomeItem(index, "images/find.svg", "变美助手"));
      pages.add(findPage);
      index++;
    }
  }

  void onTap(int index) {
    widgetLive.notifyView(index);
  }
}
