/*
 * @author lsy
 * @date   2019-11-22
 **/
import 'dart:ui' as ui;

import 'package:flutter/cupertino.dart';
import 'package:flutter/src/gestures/drag_details.dart';

class PointItem {
  List<ui.Offset> list = new List();
  List<ui.Offset> tempList = new List();
  ui.Image image;
  double x = -1;
  double y = -1;
  double scareSize = 1;
  double tranX = 0;
  double tranY = 0;
  bool drawPath = false;
  bool rectModel = false;
  bool isDown = false;
  ui.Rect rect = new Rect.fromLTRB(100, 100, 200, 200);
  ui.Rect rectTemp = new Rect.fromLTRB(100, 100, 200, 200);
  double downX, downY;

  void reset() {
    list.clear();
    x = -1;
    y = -1;
    scareSize = 1;
    tranY = 0;
    tranX = 0;
    drawPath = false;
    rect = new Rect.fromLTRB(100, 100, 200, 200);
  }

  PointItem();

  setScareSize(double scareSize) {
    if (scareSize < 1) {
      scareSize = 1;
    }
    this.scareSize = scareSize;
  }

  double getScareSize() {
    return scareSize;
  }

  setTranX(double tranX) {
    if (tranX < 0) {
      tranX = 0;
    }
    this.tranX = tranX;
  }

  double getTranX() {
    return tranX;
  }

  setTranY(double tranY) {
    if (tranY < 0) {
      tranY = 0;
    }
    this.tranY = tranY;
  }

  double getTranY() {
    return tranY;
  }

  List<ui.Offset> getPoints() {
    return list;
  }

  addPoint(double x, double y) {
    if (rectModel) {
      return;
    }
    double realX = (x / scareSize + getTranX());
    double realY = (y / scareSize + getTranY());
    list.add(new ui.Offset(realX, realY));
  }

  removePoint() {
    if (rectModel) {
      return;
    }
    if (list.isNotEmpty) {
      list.removeAt(list.length - 1);
      drawPath = false;
    }
  }

  setImage(ui.Image image) {
    this.image = image;
  }

  ui.Image getImage() {
    return image;
  }

  setX(double x) {
    this.x = x;
  }

  setY(double y) {
    this.y = y;
  }

  double getX() {
    return x;
  }

  double getY() {
    return y;
  }

  void close() {
    if (rectModel) {
      return;
    }
    if (list.isNotEmpty && list.length > 2) {
      list.add(list[0]);
      drawPath = true;
    }
  }

  void drag(DragUpdateDetails details, double startTranX, double dragStartX,
      double startTranY, double dragStartY, bool dragMark) {
    double diffX = (details.localPosition.dx - dragStartX) / scareSize;
    double diffY = (details.localPosition.dy - dragStartY) / scareSize;
    bool pkWin = true;

    if (drawPath && dragMark && isDown) {
      pkWin = false;
      list.clear();
      for (int i = 0; i < tempList.length; i++) {
        list.add(Offset(tempList[i].dx + diffX, tempList[i].dy + diffY));
      }
      print(
          "TRAN ${(details.localPosition.dx - dragStartX)} ${(details.localPosition.dy - dragStartY)}");
    }

    //rectModel && scareSize == 1 ||
    //&& scareSize != 1
    if (rectModel && isDown) {
      print(" ${downX} ${downY}   ${rectTemp.left}  ${rectTemp.top}");
      //drag item
      if (downX > rectTemp.left + 5 &&
          downX < rectTemp.right - 5 &&
          downY > rectTemp.top + 5 &&
          downY < rectTemp.bottom - 5) {
        pkWin = false;
        rect = new Rect.fromLTRB(rectTemp.left + diffX, rectTemp.top + diffY,
            rectTemp.right + diffX, rectTemp.bottom + diffY);
      }

      //left TOP
      if (downX > rectTemp.left - 5 &&
          downX < rectTemp.left + 5 &&
          downY > rectTemp.top - 5 &&
          downY < rectTemp.top + 5) {
        pkWin = false;
        double left = rectTemp.left + diffX;
        double right = rectTemp.right;
        double top = rectTemp.top + diffY;
        double bottom = rectTemp.bottom;
        if (rectTemp.left + diffX + 10 >= rectTemp.right) {
          right = rectTemp.left + diffX + 10;
        }
        if (rectTemp.top + diffY + 10 >= rectTemp.bottom) {
          bottom = rectTemp.top + diffY + 10;
        }
        rect = new Rect.fromLTRB(left, top, right, bottom);
      }
      if ((downX) > (rectTemp.right - 5) &&
          (downX) < (rectTemp.right + 5) &&
          (downY) > (rectTemp.bottom - 5) &&
          (downY) < (rectTemp.bottom + 5)) {
        pkWin = false;
        //right bottom
        double left = (rectTemp.left);
        double right = (rectTemp.right + diffX);
        double top = (rectTemp.top);
        double bottom = (rectTemp.bottom + diffY);
        if ((rectTemp.right + diffX - 10) <= (rectTemp.left)) {
          left = (right - 10);
        }
        if ((rectTemp.bottom + diffY - 10) <= (rectTemp.top)) {
          top = (bottom - 10);
        }
        rect = new Rect.fromLTRB(left, top, right, bottom);
      }
    }
    if (pkWin && scareSize != 1) {
      setTranX(
          startTranX - (details.localPosition.dx - dragStartX) / scareSize);
      setTranY(
          startTranY - (details.localPosition.dy - dragStartY) / scareSize);
    }
  }

  double getRealPosX(double pos) {
    return (pos / scareSize + getTranX());
  }

  double getRealPosY(double pos) {
    return pos / scareSize + getTranY();
  }

  void down(double tapStartX, double tapStartY, bool dragMask) {
    isDown = true;
    if (rectModel) {
      downX = getRealPosX(tapStartX);
      downY = getRealPosY(tapStartY);
      rectTemp = new Rect.fromLTRB(
          (rect.left), (rect.top), (rect.right), (rect.bottom));
    }
    if (drawPath) {
      tempList = [];
      tempList.addAll(list);
    }
  }

  void dragEnd(DragEndDetails details) {
    isDown = false;
  }
}
