/*
 * @author lsy
 * @date   2019-12-09
 **/
import 'dart:math';

import 'package:example_flutter/HomeModel/page/checkInfo/CheckInfoPage.dart';
import 'package:example_flutter/HomeModel/service/HomeRepo.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/ImageResultBean.dart';
import 'package:example_flutter/HomeModel/util/JumpUtil.dart';
import 'package:example_flutter/commonModel/GMBase.dart';
import 'package:example_flutter/commonModel/picker/base/BasePickerComponent.dart';
import 'package:example_flutter/commonModel/toast/toast.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/src/widgets/framework.dart';

class CheckModel extends BaseModel {
  LiveData<int> pageIndexLive = new LiveData();
  LiveData<List<PicList>> checkItemLive = new LiveData();
  LiveData<String> titleLive = new LiveData();
  HomeRepo _repo = HomeRepo.getInstance();

  //0 标签 1 mask ..
  int state = 0;

  @override
  void dispose() {
    pageIndexLive.dispost();
    checkItemLive.dispost();
    titleLive.dispost();
  }

  void changeState(BuildContext context, int sta, String title) {
    checkItemLive.notifyView(null);
    state = sta;
    if (sta == 0) {
      getData(context, true);
    } else if (sta == 1) {
      getMaskData(context, true);
    }
    titleLive.notifyView(title);
  }

  void getMaskData(BuildContext context, bool showDialog) {
    if (showDialog) {
      BaseCenterPicker()
        ..setPicker(BaseLoadingItem("加载中..."))
        ..show(context);
    }
    HomeRepo.getInstance()
        .getCheckMaskList(HomeRepo.getInstance().nowCheckMaskPageIndex)
        .listen((value) {
      if (showDialog) {
        Navigator.pop(context);
      }
      _repo.updateCheckMaskList(value.picList);
      checkItemLive.notifyView(value.picList);
      pageIndexLive.notifyView(_repo.nowCheckMaskPageIndex);
    }).onError((error) {
      if (showDialog) {
        Navigator.pop(context);
      }
      Toast.show(context, error.toString());
      print(error.toString());
    });
  }

  void getData(BuildContext context, bool showDialog) {
    if (showDialog) {
      BaseCenterPicker()
        ..setPicker(BaseLoadingItem("加载中..."))
        ..show(context);
    }
    titleLive.notifyView("标记列表");
    HomeRepo.getInstance()
        .getCheckList(HomeRepo.getInstance().nowCheckPageIndex)
        .listen((value) {
      if (showDialog) {
        Navigator.pop(context);
      }
      _repo.updateCheckList(value.picList);
      checkItemLive.notifyView(value.picList);
      pageIndexLive.notifyView(_repo.nowCheckPageIndex);
    }).onError((error) {
      if (showDialog) {
        Navigator.pop(context);
      }
      Toast.show(context, error.toString());
      print(error.toString());
    });
  }

  void checkClick(BuildContext context, String id, int index) {
    JumpUtil.jumpToPage(context, CheckInfoPage(state, id, index)).then((value) {
      if (state == 0) {
        getData(context, false);
      } else if (state == 1) {
        getMaskData(context, false);
      }
    });
  }

  void after(BuildContext context) {
    BaseCenterPicker()
      ..setPicker(BaseLoadingItem("加载中。。。"))
      ..show(context);
    if (state == 0) {
      _repo.getCheckList(_repo.nowCheckPageIndex + 1).listen((data) {
        if (data == null || data.picList == null || data.picList.isEmpty) {
          Toast.show(context, "已经是最后一页了哦～");
        } else {
          _repo.nowCheckPageIndex = _repo.nowCheckPageIndex + 1;
          _repo.updateCheckList(data.picList);
          checkItemLive.notifyView(data.picList);
        }
        pageIndexLive.notifyView(_repo.nowCheckPageIndex);
        Navigator.pop(context);
      }).onError((error) {
        Toast.show(context, error.toString());
        Toast.show(context, "没有下一页了");
        print(error.toString());
        Navigator.pop(context);
      });
    } else if (state == 1) {
      _repo.getCheckMaskList(_repo.nowCheckMaskPageIndex + 1).listen((data) {
        if (data == null || data.picList == null || data.picList.isEmpty) {
          Toast.show(context, "已经是最后一页了哦～");
        } else {
          _repo.nowCheckMaskPageIndex = _repo.nowCheckMaskPageIndex + 1;
          _repo.updateCheckMaskList(data.picList);
          checkItemLive.notifyView(data.picList);
        }
        pageIndexLive.notifyView(_repo.nowCheckMaskPageIndex);
        Navigator.pop(context);
      }).onError((error) {
        Toast.show(context, error.toString());
        Toast.show(context, "没有下一页了");
        print(error.toString());
        Navigator.pop(context);
      });
    }
  }

  void before(BuildContext context) {
    if (state == 0) {
      if (_repo.nowCheckPageIndex == 1) {
        Toast.show(context, "已经是第一页了哦");
        return;
      }
      _repo.nowCheckPageIndex = _repo.nowCheckPageIndex - 1;
      getData(context, true);
      pageIndexLive.notifyView(_repo.nowCheckPageIndex);
    } else if (state == 1) {
      if (_repo.nowCheckMaskPageIndex == 1) {
        Toast.show(context, "已经是第一页了哦");
        return;
      }
      _repo.nowCheckMaskPageIndex = _repo.nowCheckMaskPageIndex - 1;
      getMaskData(context, true);
      pageIndexLive.notifyView(_repo.nowCheckMaskPageIndex);
    }
  }
}
