/*
 * @author lsy
 * @date   2019-12-09
 **/
import 'package:example_flutter/HomeModel/base/BaseTitle.dart';
import 'package:example_flutter/HomeModel/page/work/temp.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/ImageResultBean.dart';
import 'package:example_flutter/commonModel/base/BaseComponent.dart';
import 'package:example_flutter/commonModel/base/BaseState.dart';
import 'package:example_flutter/commonModel/cache/CacheManager.dart';
import 'package:example_flutter/res/GMRes.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

import 'CheckModel.dart';

class CheckPage extends StatefulWidget {
  @override
  State<StatefulWidget> createState() => CheckState();
}

class CheckState extends State<CheckPage> {
  bool isChecker = false;

  CheckModel _model;

  @override
  void initState() {
    isChecker =
    (CacheManager.getInstance().get(MEMORY_CACHE).get("checkId")==null ? -1:CacheManager.getInstance().get(MEMORY_CACHE).get("checkId") == 1);
    _model = CheckModel();
    if (isChecker) {
      _model.getData(context, false);
    }
    super.initState();
  }

  @override
  void dispose() {
    _model.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: MyAppBar(),
      body: isChecker
          ? Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                FixLeft(),
                Expanded(
                  child: RightItem(),
                )
              ],
            )
          : Center(
              child: baseText("这个账号没有审核权限哦", 18, Colors.black),
            ),
    );
  }

  Widget RightItem() {
    return Card(
      elevation: 5,
      margin: EdgeInsets.only(left: 30, top: 30, right: 200, bottom: 50),
      child: Container(
        child: Column(
          children: <Widget>[rightTitle(), rightBody(), rightFoot()],
        ),
      ),
    );
  }

  Widget rightTitle() {
    return Container(
        width: double.maxFinite,
        height: 50,
        color: Colors.red,
        alignment: Alignment.center,
        child: StreamBuilder(
          stream: _model.titleLive.stream,
          initialData: "",
          builder: (con, data) {
            return baseText("审查列表  --  ${data.data}", 15, Colors.black);
          },
        ));
  }

  Widget rightFoot() {
    return Container(
      width: double.maxFinite,
      height: 50,
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.center,
        children: <Widget>[
          baseButton(() {
            if(_model.state==0){
              _model.getData(context, true);
            }else if(_model.state==1){
              _model.getMaskData(context, true);
            }
          }, EdgeInsets.only(), "刷新"),
//          baseButton(() {}, EdgeInsets.only(), ""),
//          baseButton(() {}, EdgeInsets.only(), ""),
//          baseButton(() {}, EdgeInsets.only(), ""),
          Expanded(
            child: Container(),
          ),
          GestureDetector(
              behavior: HitTestBehavior.opaque,
              onTap: () {
                _model.before(context);
              },
              child: Container(
                alignment: Alignment.center,
                width: 38,
                height: 38,
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(5.0),
                  border: Border.all(color: Colors.orange, width: 2),
                ),
                child: Icon(
                  Icons.arrow_left,
                  color: Colors.orange,
                ),
              )),
          GestureDetector(
              behavior: HitTestBehavior.opaque,
              onTap: () {},
              child: Container(
                  margin: EdgeInsets.only(left: 5, right: 5),
                  alignment: Alignment.center,
                  width: 38,
                  height: 38,
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(5.0),
                    border: Border.all(color: Colors.orange, width: 2),
                  ),
                  child: StreamBuilder<int>(
                    stream: _model.pageIndexLive.stream,
                    initialData: 1,
                    builder: (con, data) {
                      return baseText("${data.data}", 13, Colors.orange);
                    },
                  ))),
          GestureDetector(
              behavior: HitTestBehavior.opaque,
              onTap: () {
                _model.after(context);
              },
              child: Container(
                alignment: Alignment.center,
                width: 38,
                height: 38,
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(5.0),
                  border: Border.all(color: Colors.orange, width: 2),
                ),
                child: Icon(
                  Icons.arrow_right,
                  color: Colors.orange,
                ),
              )),
          Container(
            width: 30,
          )
        ],
      ),
    );
  }

  Widget rightBody() {
    return Expanded(
      child: Container(
          child: StreamBuilder<List<PicList>>(
        stream: _model.checkItemLive.stream,
        initialData: [],
        builder: (con, data) {
          List<Widget> list = [
            Item(ALColors.ColorTitle, "id", null, "名称", "标注者", "审查类型", "质检状态",
                "完成时间", -1)
          ];
          list.add(baseDivideColumn());
          int index = 0;
          if (data.data != null) {
            data.data.forEach((value) {
              list.add(Item(
                  Colors.white,
                  "${value.id}",
                  value.picurl,
                  value.picurl.substring(
                      value.picurl.lastIndexOf("/") + 1, value.picurl.length),
                  "未知",
                  _model.state == 0 ? "标记审查" : "点审查",
                  STATEEXPLAIN[value.status],
                  "未知",
                  index));
              index++;
              list.add(baseDivideColumn());
            });
          }
          print(list.length);
          return ListView(
            children: list,
          );
        },
      )),
    );
  }

  Widget Item(Color color, String id, String url, String name, String persion,
      String type, String state, String date, int index) {
    return GestureDetector(
        behavior: HitTestBehavior.opaque,
        onTap: () {
          if (index != -1) {
            _model.checkClick(context, id, index);
          }
        },
        child: Container(
            width: double.maxFinite,
            height: 50,
            color: color,
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.center,
              children: <Widget>[
                Container(
                  alignment: Alignment.center,
                  height: 50,
                  width: 50,
                  child: Container(
                    child: baseText(id, 13, Colors.black),
                  ),
                ),
                baseDivideRow(),
                Expanded(
                  child: Container(
                    alignment: Alignment.center,
                    child: url == null
                        ? baseText("图片", 13, Colors.black)
                        : Image.network(
                            url,
                            height: double.maxFinite,
                            fit: BoxFit.fitHeight,
                          ),
                  ),
                ),
                baseDivideRow(),
                Expanded(
                  child: Container(
                    alignment: Alignment.center,
                    child: baseText(name, 13, Colors.black),
                  ),
                ),
                baseDivideRow(),
                Expanded(
                  child: Container(
                    alignment: Alignment.center,
                    child: baseText(persion, 13, Colors.black),
                  ),
                ),
                baseDivideRow(),
                Expanded(
                  child: Container(
                    alignment: Alignment.center,
                    child: baseText(state, 13, Colors.black),
                  ),
                ),
                baseDivideRow(),
                Expanded(
                  child: Container(
                    alignment: Alignment.center,
                    child: baseText(type, 13, Colors.black),
                  ),
                ),
                baseDivideRow(),
                Expanded(
                  child: Container(
                    alignment: Alignment.center,
                    child: baseText(date, 13, Colors.black),
                  ),
                )
              ],
            )));
  }

  Widget FixLeft() {
    return Card(
      elevation: 5,
      margin: EdgeInsets.only(left: 50, top: 30),
      child: Container(
        width: 120,
        height: 300,
        child: Column(
          children: <Widget>[
            Container(
              height: 30,
            ),
            baseFlatButtonItem(() {
              _model.changeState(context, 0, "标记列表");
            }, "标记列表"),
            baseFlatButtonItem(() {
              _model.changeState(context, 1, "点列表");
            }, "点列表"),
            baseFlatButtonItem(() {}, "TODO"),
            Expanded(
              child: Container(),
            ),
          ],
        ),
      ),
    );
  }
}
