/*
 * @author lsy
 * @date   2019-12-09
 **/
import 'dart:io';

import 'package:example_flutter/HomeModel/base/BaseTitle.dart';
import 'package:example_flutter/HomeModel/base/bean/PointItem.dart';
import 'package:example_flutter/HomeModel/page/work/temp.dart';
import 'package:example_flutter/HomeModel/service/HomeRepo.dart';
import 'package:example_flutter/HomeModel/util/ParseUtil.dart';
import 'package:example_flutter/commonModel/GMBase.dart';
import 'package:example_flutter/commonModel/cache/CacheManager.dart';
import 'package:example_flutter/commonModel/picker/base/BasePickerComponent.dart';
import 'package:example_flutter/commonModel/toast/toast.dart';
import 'package:example_flutter/commonModel/util/ImageUtil.dart';
import 'package:flutter/material.dart';

class CheckInfoModel implements BaseModel {
  LiveData<PointItem> pointLive = new LiveData();
  LiveData<List<int>> nowIndexLive = new LiveData();
  LiveData<String> maskTabLive = new LiveData();
  LiveData<bool> needHelpLineLive = new LiveData();
  LiveData<Map<String, List<List<String>>>> tabLive = new LiveData();
  LiveData<Map<String, List<List<String>>>> selectLive = new LiveData();
  Map<String, List<List<String>>> selectMap = new Map();
  PointItem pointItem = new PointItem();
  int state;
  String id;
  int currentIndex;
  HomeRepo _repo = HomeRepo.getInstance();

  CheckInfoModel(this.state, this.id, this.currentIndex);

  init(BuildContext context) {
    if (state == 0) {
      needHelpLine = false;
      allTab(context, false);
      getImageResutl(context, false);
    } else if (state == 1) {
      needHelpLine = true;
    }
    getNetWorkImg(context);
    notiIndex();
    needHelpLineLive.notifyView(needHelpLine);
  }

  getImageResutl(BuildContext context, bool showPicker) {
    if (showPicker) {
      BaseCenterPicker()
        ..setPicker(BaseLoadingItem("加载中..."))
        ..show(context);
    }
    HomeRepo.getInstance().imageAi(id).listen((value) {
      selectMap.clear();
      selectMap.addAll(ParseUtil.parseSelect(value));
      selectLive.notifyView(selectMap);
      if (showPicker) {
        Navigator.pop(context);
      }
    }).onError((error) {
      Toast.show(context, error.toString());
      print(error.toString());
      if (showPicker) {
        Navigator.pop(context);
      }
    });
  }

  void deleteSelectItem(BuildContext context, String key, String title) {
    BaseCenterPicker()
      ..setPicker(SurePicker("确定删除这个条目吗？", () {
        Navigator.pop(context);
      }, () {
        Navigator.pop(context);
        var selectList = selectMap[key];
        if (selectList != null && selectList.isNotEmpty) {
          if (selectList.length == 1) {
            selectMap.remove(key);
          } else {
            int index = -1;
            for (int i = 0; i < selectList.length; i++) {
              if (selectList[i][0] == title) {
                index = i;
              }
            }
            if (index != -1) {
              selectList.removeAt(index);
            }
          }
        }
        selectLive.notifyView(selectMap);
      }))
      ..show(context);
  }

  allTab(BuildContext context, bool showPicker) {
    if (showPicker) {
      BaseCenterPicker()
        ..setPicker(BaseLoadingItem("加载中"))
        ..show(context);
    }
    HomeRepo.getInstance().getAllTab().listen((value) {
      tabLive.notifyView(ParseUtil.changTabToList(value));
      if (showPicker) {
        Navigator.pop(context);
      }
    }).onError((error) {
      Toast.show(context, error.toString());
      print(error.toString());
      if (showPicker) {
        Navigator.pop(context);
      }
    });
  }

  notiIndex() {
    if (state == 0) {
      nowIndexLive.notifyView(
          [HomeRepo.getInstance().nowCheckPageIndex, currentIndex + 1]);
    } else if (state == 1) {
      nowIndexLive.notifyView(
          [HomeRepo.getInstance().nowCheckMaskPageIndex, currentIndex + 1]);
    }
  }

  void selectItem(String key, String title, String result) {
    List<List<String>> innlist = selectMap[key];
    if (innlist == null || innlist.isEmpty) {
      selectMap[key] = [
        [title, result]
      ];
    } else {
      int index = -1;
      for (int i = 0; i < innlist.length; i++) {
        if (innlist[i][0] == title) {
          index = i;
          break;
        }
      }
      if (index != -1) {
        innlist[index][1] = result;
      } else {
        List<String> list = [title, result];
        innlist.add(list);
      }
    }
    selectLive.notifyView(selectMap);
  }

  @override
  void dispose() {
    tabLive.dispost();
    selectLive.dispost();
    pointLive.dispost();
    nowIndexLive.dispost();
    maskTabLive.dispost();
    needHelpLineLive.dispost();
  }

  void getNetWorkImg(BuildContext context) {
    if (state == 0) {
      loadNetWorkImage(HomeRepo.getInstance().checkList[currentIndex].picurl)
          .then((value) {
        pointItem.reset();
        pointItem.setImage(value);
        pointLive.notifyView(pointItem);
      }).catchError((error) {
        Toast.show(context, error.toString());
        print(error.toString());
      });
    } else if (state == 1) {
      loadNetWorkImage(
              HomeRepo.getInstance().checkMaskList[currentIndex].picurl)
          .then((value) {
        pointItem.reset();
        pointItem.setImage(value);
        pointLive.notifyView(pointItem);
      }).catchError((error) {
        Toast.show(context, error.toString());
        print(error.toString());
      });
    }
  }

  void syncPoint() {
    pointLive.notifyView(pointItem);
  }

  void saveDrawImage(
      BuildContext context, double picScare, double topBuf, double topAdd) {
    if (maskTabLive.data == null) {
      Toast.show(context, "得选着一个标签哦");
      return;
    }
    print("SCARE =====  >>>>> $picScare");
    if (pointItem.list.isEmpty) {
      Toast.show(context, "还没有标记数据哦～");
      return;
    }
    BaseCenterPicker()
      ..setPicker(BaseLoadingItem("保存中..."))
      ..show(context);
    List<int> uploadList = [];
    pointItem.list.forEach((off) {
      uploadList.add((off.dx * picScare).toInt());
      print("TOPPPP AADD  ${topAdd}  ${topBuf}");
      if (topAdd < 0) {
        uploadList.add(((off.dy - topAdd) * picScare).toInt());
      } else {
        uploadList.add(((off.dy - topBuf) * picScare).toInt());
      }
    });
    if (uploadList.isNotEmpty) {
      getTempDirX(context, (dir) {
        var savePath = "${dir}/${DateTime.now().millisecondsSinceEpoch}.jpeg";
        DioUtil()
            .getDio()
            .download(
                state == 0
                    ? _repo.checkList[_repo.nowCheckPageIndex].picurl
                    : _repo.checkMaskList[_repo.nowCheckMaskPageIndex].picurl,
                savePath)
            .whenComplete(() {
          String uploadPath =
              "${dir}/sign${DateTime.now().millisecondsSinceEpoch}.jpeg";
          toImage(uploadList, uploadPath, savePath).whenComplete(() {
//            HomeRepo.getInstance()
//                .maskImage(uploadPath, imageId, maskExplain[maskTabLive.data],
//                    listToUi(pointItem.list))
//                .listen((value) {
//              if (value != null) {
//                Toast.show(context, "保存成功");
//                Navigator.pop(context);
//                File(uploadPath).delete();
//                Navigator.pop(context);
//              }
//            }).onError((error) {
//              Toast.show(context, error.toString());
//              print(error.toString());
//              Navigator.pop(context);
//            });

            print("HERE WWWWW");

            //TODO HERE  WWWWw
            String realSavePath =
                "${dir}/mask${DateTime.now().millisecondsSinceEpoch}.png";
            _repo.uploadMyImage(uploadPath, "${id}").listen((value) {
              _repo.downloadMyImage(realSavePath, value.fileId, () {
                print("UPLOAD MY OKKKKK");
//                toImageTest(uploadList, "${dir}/test${DateTime.now().millisecondsSinceEpoch}.jpeg",savePath ).whenComplete((){});
                File(savePath).delete();
                File(uploadPath).delete();
//                Timer(Duration(seconds: 2),(){
                HomeRepo.getInstance()
                    .maskImage(realSavePath, id, maskExplain[maskTabLive.data],
                        listToUi(pointItem.list), 1)
                    .listen((value) {
                  if (value != null) {
                    Toast.show(context, "保存成功");
                    Navigator.pop(context);
                    Navigator.pop(context);
                  }
                }).onError((error) {
                  Toast.show(context, error.toString());
                  print(error.toString());
                  Navigator.pop(context);
                });
//                });
              });
            }).onError((error) {
              Toast.show(context, error.toString());
              print(error.toString());
              Navigator.pop(context);
            });
          }).catchError((error) {
            Navigator.pop(context);
            Toast.show(context, "保存失败");
            print(error.toString());
          });
        });
      });
    }
  }

  void syncPos(double dx, double dy) {
    pointItem.setX(dx);
    pointItem.setY(dy);
    pointLive.notifyView(pointItem);
  }

  bool needHelpLine = true;

  void needHelpLineNotify(bool value) {
    needHelpLine = value;
    needHelpLineLive.notifyView(needHelpLine);
    syncPos(-10, -10);
  }

  void imageNext(BuildContext context) {
    if (state == 0) {
      if (currentIndex == 8) {
        _repo.getCheckList(_repo.nowCheckPageIndex + 1).listen((data) {
          if (data == null || data.picList == null || data.picList.isEmpty) {
            Toast.show(context, "已经是最后一张了哦～");
          } else {
            currentIndex = 0;
            _repo.nowCheckPageIndex = _repo.nowCheckPageIndex + 1;
            _repo.updateCheckList(data.picList);
            getNetWorkImg(context);
            id = "${_repo.checkList[currentIndex].id}";
            nowIndexLive
                .notifyView([_repo.nowCheckPageIndex, currentIndex + 1]);
            selectLive.notifyView(null);
            getImageResutl(context, false);
          }
        }).onError((error) {
          Toast.show(context, error.toString());
          print(error.toString());
        });
      } else {
        if (currentIndex + 1 > _repo.checkList.length - 1) {
          Toast.show(context, "已经是最后一张了哦～");
          return;
        }
        currentIndex = currentIndex + 1;
        getNetWorkImg(context);
        id = "${_repo.checkList[currentIndex].id}";
        selectLive.notifyView(null);
        getImageResutl(context, false);
        nowIndexLive.notifyView([_repo.nowCheckPageIndex, currentIndex + 1]);
      }
    } else if (state == 1) {
      if (currentIndex == 8) {
        _repo.getCheckMaskList(_repo.nowCheckMaskPageIndex + 1).listen((data) {
          if (data == null || data.picList == null || data.picList.isEmpty) {
            Toast.show(context, "已经是最后一张了哦～");
          } else {
            currentIndex = 0;
            _repo.nowCheckMaskPageIndex = _repo.nowCheckMaskPageIndex + 1;
            _repo.updateCheckMaskList(data.picList);
            getNetWorkImg(context);
            id = "${_repo.checkMaskList[currentIndex].id}";
            nowIndexLive
                .notifyView([_repo.nowCheckMaskPageIndex, currentIndex + 1]);
            selectLive.notifyView(null);
            getImageResutl(context, false);
          }
        }).onError((error) {
          Toast.show(context, error.toString());
          print(error.toString());
        });
      } else {
        if (currentIndex + 1 > _repo.checkMaskList.length - 1) {
          Toast.show(context, "已经是最后一张了哦～");
          return;
        }
        currentIndex = currentIndex + 1;
        getNetWorkImg(context);
        id = "${_repo.checkMaskList[currentIndex].id}";
        selectLive.notifyView(null);
        getImageResutl(context, false);
        nowIndexLive
            .notifyView([_repo.nowCheckMaskPageIndex, currentIndex + 1]);
      }
    }
  }

  void imageBefore(BuildContext context) {
    if (state == 0) {
      if (currentIndex == 0) {
        if (_repo.nowCheckPageIndex == 1) {
          Toast.show(context, "已经是第一张了哦～");
          return;
        }
        _repo.nowCheckPageIndex = _repo.nowCheckPageIndex - 1;
        _repo.getCheckList(_repo.nowCheckPageIndex).listen((data) {
          currentIndex = 8;
          _repo.updateCheckList(data.picList);
          getNetWorkImg(context);
          id = "${_repo.checkList[currentIndex].id}";
          selectLive.notifyView(null);
          getImageResutl(context, false);
          nowIndexLive.notifyView([_repo.nowCheckPageIndex, currentIndex + 1]);
        }).onError((error) {
          Toast.show(context, error.toString());
          print(error.toString());
        });
      } else {
        currentIndex = currentIndex - 1;
        getNetWorkImg(context);
        id = "${_repo.checkList[currentIndex].id}";
        selectLive.notifyView(null);
        getImageResutl(context, false);
        nowIndexLive.notifyView([_repo.nowCheckPageIndex, currentIndex + 1]);
      }
    } else if (state == 1) {
      if (currentIndex == 0) {
        if (_repo.nowCheckMaskPageIndex == 1) {
          Toast.show(context, "已经是第一张了哦～");
          return;
        }
        _repo.nowCheckMaskPageIndex = _repo.nowCheckMaskPageIndex - 1;
        _repo.getCheckMaskList(_repo.nowCheckMaskPageIndex).listen((data) {
          currentIndex = 8;
          _repo.updateCheckMaskList(data.picList);
          getNetWorkImg(context);
          id = "${_repo.checkMaskList[currentIndex].id}";
          selectLive.notifyView(null);
          getImageResutl(context, false);
          nowIndexLive
              .notifyView([_repo.nowCheckMaskPageIndex, currentIndex + 1]);
        }).onError((error) {
          Toast.show(context, error.toString());
          print(error.toString());
        });
      } else {
        currentIndex = currentIndex - 1;
        getNetWorkImg(context);
        id = "${_repo.checkMaskList[currentIndex].id}";
        selectLive.notifyView(null);
        getImageResutl(context, false);
        nowIndexLive
            .notifyView([_repo.nowCheckMaskPageIndex, currentIndex + 1]);
      }
    }
  }

  void save(BuildContext context, bool param1) {
    BaseCenterPicker()
      ..setPicker(BaseLoadingItem("保存中..."))
      ..show(context);
    StringBuffer stringBuffer = new StringBuffer();
    stringBuffer.write("""
    {"face_details":{
    """);
    List<List<String>> finalResult = new List();
    selectMap.forEach((key, value) {
      for (int i = 0; i < value.length; i++) {
        String before;
        EXPLAN.forEach((k, v) {
          if (v == value[i][0]) {
            before = k;
          }
        });
        finalResult.add([before, value[i][1]]);
      }
    });
    for (int i = 0; i < finalResult.length; i++) {
      stringBuffer.write("""
        "${finalResult[i][0]}":"${finalResult[i][1]}"
      """);
      if (i != finalResult.length - 1) {
        stringBuffer.write(",");
      }
    }
    stringBuffer.write("""
    },"audit_id": "${CacheManager.getInstance().get(MEMORY_CACHE).get("uid")}"}
    """);
    print("====>  ${stringBuffer.toString()}");
    _repo.saveCheckResult(id, stringBuffer.toString()).listen((value) {
      if (value != null) {
        Navigator.pop(context);
        imageNext(context);
//        Navigator.pop(context, -1);
        Toast.show(context, "保存成功");
      }
    }).onError((error) {
      Toast.show(context, error.toString());
      print(error.toString());
      Navigator.pop(context);
    });
  }

  void getMaskedImage(BuildContext context) {
    if (maskTabLive.data == null) {
      Toast.show(context, "请先选着标签");
      return;
    }
    BaseCenterPicker()
      ..setPicker(BaseLoadingItem("加载中..."))
      ..show(context);
    HomeRepo.getInstance()
        .getMaskInfo(id, maskExplain[maskTabLive.data], 1)
        .listen((value) {
      print(value.picurl);
      if (value != null && value.ui != null && value.ui.isNotEmpty) {
        pointItem.list = uiToList(value.ui);
        pointItem.drawPath = true;
        syncPoint();
      }
      Navigator.pop(context);
    }).onError((error) {
      Toast.show(context, error.toString());
      print(error.toString());
      Navigator.pop(context);
    });
  }

  void showMaskTabSelect(BuildContext context) {
    showModalBottomSheet(
        context: context,
        builder: (BuildContext context) {
          List<Widget> list = new List();
          maskTabList.forEach((value) {
            list.add(new ListTile(
              leading: new Icon(Icons.select_all),
              title: new Text(value),
              onTap: () async {
                Navigator.pop(context);
                maskTabLive.notifyView(value);
              },
            ));
          });
          return new Column(mainAxisSize: MainAxisSize.min, children: list);
        });
  }
}
