/*
 * @author lsy
 * @date   2019-12-03
 **/
import 'package:example_flutter/commonModel/GMBase.dart';
import 'package:example_flutter/commonModel/toast/toast.dart';
import 'package:flutter/cupertino.dart';

class CreateProjectModel extends BaseModel {
  LiveData<int> currentIndexLive = new LiveData();
  LiveData<ProjectUI> projectLive = new LiveData();

  CreateProjectModel() {
    currentIndexLive.notifyView(1);
    var projectUI = ProjectUI();
    projectUI.index = 1;
    projectLive.notifyView(projectUI);
  }

  tabChange(int tab) {
    currentIndexLive.notifyView(tab);
    projectLive.data.index = tab;
    projectLive.notifyView(projectLive.data);
  }

  @override
  void dispose() {
    projectLive.dispost();
    currentIndexLive.dispost();
  }

  void next(BuildContext context, String text, String text2) {
    if (text.isEmpty || text2.isEmpty) {
      Toast.show(context, "清输入项目名称和描述哦");
      return;
    }
    projectLive.data.name = text;
    projectLive.data.content = text2;
    //TODO
    projectLive.data.way = "图像";
    projectLive.data.index = 2;
    currentIndexLive.notifyView(2);
    projectLive.notifyView(projectLive.data);
  }
}

class ProjectUI {
  int index;
  String name;
  String content;
  String way;
  String dataList;
}
