/*
 * @author lsy
 * @date   2019-11-22
 **/
import 'dart:async';
import 'dart:ui';

import 'package:example_flutter/HomeModel/base/bean/PointItem.dart';
import 'package:flutter/material.dart';
import 'package:flutter_animation_set/animation_set.dart';
import 'dart:ui' as ui;
import 'dart:math' as math;

import 'package:flutter_animation_set/animator.dart';

class MyYYRotatingCircle extends StatelessWidget {
  Color color;

  MyYYRotatingCircle(this.color);

  @override
  Widget build(BuildContext context) {
    return Container(
      width: 40,
      height: 40,
      child: Stack(
        children: <Widget>[
          AnimatorSet(
            child: Container(
              decoration: BoxDecoration(
                color: color,
                shape: BoxShape.circle,
              ),
              width: 100,
              height: 100,
            ),
            animatorSet: [
              RX(from: 0.0, to: math.pi, duration: 500, curve: Curves.easeIn),
              RY(from: 0.0, to: math.pi, duration: 500, curve: Curves.easeOut),
            ],
          ),
        ],
      ),
    );
  }
}

class UploadHideView extends CustomPainter {
  double animValue;
  double progressValue;
  int state;
  String reason;

  UploadHideView(this.state, this.animValue, this.progressValue,this.reason);

  Paint ImagePaint = new Paint()..isAntiAlias = true;

  Paint circlePaint = new Paint()
    ..isAntiAlias = true
    ..color = Colors.black38
    ..style = PaintingStyle.fill;

  Paint rectPaint = new Paint()
    ..isAntiAlias = true
    ..color = Colors.red
    ..strokeWidth = 5
    ..style = PaintingStyle.stroke
    ..strokeCap = StrokeCap.round;

  Path path = new Path();

  @override
  void paint(Canvas canvas, Size size) {
    RRect rect1 = RRect.fromRectAndRadius(
        new Rect.fromLTWH(0, 0, size.width, size.height),
        Radius.circular(15.0));
    canvas.clipRRect(rect1);
    if (state == 0) {
//      if (progressValue == 0.1) {
//        canvas.drawRect(
//            Rect.fromLTWH(0, 0, size.width, size.height), circlePaint);
//      } else {
//        double rowHeight = size.width / 15;
//        path.moveTo(0, 0);
//        path.relativeLineTo(size.width * 3, 0);
//        path.relativeLineTo(0, size.height / 2);
//        path.relativeCubicTo(
//            0, 0, -size.width / 6, -rowHeight, -size.width / 3, 0);
//        path.relativeCubicTo(
//            0, 0, -size.width / 6, rowHeight, -size.width / 3, 0);
//        path.relativeCubicTo(
//            0, 0, -size.width / 6, -rowHeight, -size.width / 3, 0);
//
//        path.relativeCubicTo(
//            0, 0, -size.width / 6, rowHeight, -size.width / 3, 0);
//        path.relativeCubicTo(
//            0, 0, -size.width / 6, -rowHeight, -size.width / 3, 0);
//        path.relativeCubicTo(
//            0, 0, -size.width / 6, rowHeight, -size.width / 3, 0);
//
//        path.relativeCubicTo(
//            0, 0, -size.width / 6, -rowHeight, -size.width / 3, 0);
//        path.relativeCubicTo(
//            0, 0, -size.width / 6, rowHeight, -size.width / 3, 0);
//        path.relativeCubicTo(
//            0, 0, -size.width / 6, -rowHeight, -size.width / 3, 0);
//
//        path.close();
//
//        canvas.save();
//        canvas.translate(-size.width * 2 * animValue, 0);
//        canvas.drawPath(path, circlePaint);
//        canvas.restore();
//      }
    } else if (state == 1) {
      canvas.save();
      canvas.translate(size.width - 30, size.height - 30);
      Path path = new Path();
      path.moveTo(-10, -10);
      path.lineTo(0, 0);
      path.lineTo(22, -22);
      canvas.drawPath(path, rectPaint);
      canvas.restore();
    } else if (state == 2) {
      canvas.save();
      canvas.translate(size.width / 2, size.height / 2);
      canvas.rotate(0.3);
      if(reason!=null){
        TextPainter(
            text: TextSpan(
                text: reason,
                style: TextStyle(
                    fontSize: 13,
                    color: Colors.yellow,
                    fontWeight: FontWeight.w300)),
            textDirection: TextDirection.ltr,
            textAlign: TextAlign.center)
          ..layout(maxWidth: 150, minWidth: 30)
          ..paint(canvas, Offset(-60, -30));
      }
      canvas.drawLine(Offset(-30, 30), Offset(30, -30), rectPaint);
      canvas.drawLine(Offset(30, 30), Offset(-30, -30), rectPaint);
      canvas.restore();
    }
  }

  @override
  bool shouldRepaint(CustomPainter oldDelegate) {
    return true;
  }
}
