/*
 * @author lsy
 * @date   2019-11-13
 **/
import 'package:example_flutter/HomeModel/base/BaseTitle.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/ImageResultBean.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/TotalImageBean.dart';
import 'package:example_flutter/commonModel/base/BaseComponent.dart';
import 'package:example_flutter/commonModel/base/BaseState.dart';
import 'package:example_flutter/commonModel/base/SaveKey.dart';
import 'package:example_flutter/res/GMRes.dart';
import 'package:flutter/material.dart';

import 'PicModel.dart';

class PicPage extends StatefulWidget {
  @override
  State<StatefulWidget> createState() => PicState();
}

class PicState extends BaseState<PicPage> {
  PicModel _model;
  Size screenSize;

  PicState() {
    _model = PicModel();
  }

  @override
  void initState() {
    super.initState();
    _model.getImages(context, false);
    _model.getTotalImages(context);
//    getString(context, PAGE_SAVE, (value) {
//      try {
//        print("GETVALUEEE    ${value}");
//        var parse = int.parse(value);
//        _model.getRepo().currentPage = parse;
//        _model.getImages(context, false);
//        _model.getTotalImages(context);
//      } catch (e) {
//      }
//    });
  }

  @override
  void dispose() {
    saveString(PAGE_SAVE, "${_model.getRepo().currentPage}");
    _model.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    screenSize = MediaQuery.of(context).size;
    return Scaffold(
//      appBar: getBaseTitle(context),
      body: Column(
        crossAxisAlignment: CrossAxisAlignment.center,
        children: <Widget>[
          basehead(context),
          sync(context),
          Expanded(
            child: imageList(context),
          ),
          nextBefor(context)
        ],
      ),
    );
  }

  imageList(BuildContext context) {
    for (int i = 0; i < 9; i++) {}
    return StreamBuilder<List<PicList>>(
      stream: _model.imageLive.stream,
      initialData: _model.imageLive.data,
      builder: (con, data) {
        if (data.data == null) {
          return loadingItem();
        }
        List<Widget> gridList = new List();
        for (int i = 0; i < data.data.length; i++) {
          String showText;
          Color color;
          if (data.data[i].status == "0") {
            showText = "未分配";
            color = Colors.blueGrey;
          } else if (data.data[i].status == "1") {
            showText = "已分配未标记";
            color = Colors.red;
          } else if (data.data[i].status == "2") {
            showText = "已分配已标记";
            color = Colors.green;
          }
          gridList.add(gridItem(data.data[i].picurl, showText, i, color));
        }
        return Container(
            width: double.maxFinite,
            height: double.maxFinite,
            alignment: Alignment.center,
            child: Container(
                width: screenSize.height - 80 - 58,
                height: screenSize.height - 80 - 58,
                child: GridView.count(
                  crossAxisCount: 3,
                  mainAxisSpacing: 2.0,
                  crossAxisSpacing: 2.0,
                  children: gridList,
                )));
      },
    );
  }

  gridItem(String url, String showText, int index, Color color) {
    return GestureDetector(
        onTap: () {
          _model.onItemClick(context, index);
        },
        onLongPress: () {
          _model.onDeleteItem(context, index);
        },
        child: Container(
          alignment: Alignment.bottomRight,
          decoration: BoxDecoration(
              image:
                  DecorationImage(fit: BoxFit.cover, image: NetworkImage(url))),
          child: Container(
            color: Colors.yellow,
            alignment: Alignment.center,
            width: 150,
            height: 30,
            child: baseText(showText, 15, color),
          ),
        ));
  }

  sync(BuildContext context) {
    return Container(
      width: double.maxFinite,
      height: 30,
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.center,
        children: <Widget>[
          Container(
            width: 16,
          ),
          baseText("刷新", 15, ALColors.Color323232),
          GestureDetector(
              onTap: () {
                _model.getImages(context, true);
                _model.getTotalImages(context);
              },
              child: Container(
                padding: EdgeInsets.only(left: 20),
                child: Icon(
                  Icons.sync,
                  color: Colors.black,
                ),
              )),
          Container(
            margin: EdgeInsets.only(left: 50),
            child: baseText("长按删除图片", 15, Colors.red),
          ),
          Expanded(
              child: StreamBuilder<TotalImageBean>(
            stream: _model.totalLive.stream,
            initialData: _model.totalLive.data,
            builder: (con, data) {
              if (data.data == null) {
                return loadingItem();
              }
              return Container(
                alignment: Alignment.centerRight,
                padding: EdgeInsets.only(right: 20),
                child: baseText(
                    "已标注图片的数量:${data.data.totalTag} 未标注图片的数量${data.data.total}",
                    15,
                    Colors.black),
              );
            },
          ))
        ],
      ),
    );
  }

  nextBefor(BuildContext context) {
    return Container(
      width: double.maxFinite,
      height: 50,
      child: Row(
        children: <Widget>[
          FlatButton(
            onPressed: () {
              _model.before(context);
            },
            child: Container(
              width: 100,
              height: double.maxFinite,
              alignment: Alignment.center,
              child: baseText("上一页", 15, Colors.black),
            ),
          ),
          Expanded(
              child: StreamBuilder<int>(
            stream: _model.countLive.stream,
            initialData: _model.countLive.data,
            builder: (con, data) {
              if (data.data == null) {
                return loadingItem();
              }
              return Container(
                alignment: Alignment.center,
                child: baseText("第${data.data}页", 15, Colors.black),
              );
            },
          )),
          FlatButton(
            onPressed: () {
              _model.after(context);
            },
            child: Container(
              width: 100,
              height: double.maxFinite,
              alignment: Alignment.center,
              child: baseText("下一页", 15, Colors.black),
            ),
          )
        ],
      ),
    );
  }
}
