/*
 * @author lsy
 * @date   2019-11-08
 **/
import 'dart:async';
import 'dart:io';
import 'dart:math';
import 'dart:ui' as ui;
import 'package:example_flutter/HomeModel/base/BaseTitle.dart';
import 'package:example_flutter/HomeModel/base/bean/PointItem.dart';
import 'package:example_flutter/HomeModel/page/work/temp.dart';
import 'package:example_flutter/HomeModel/service/HomeRepo.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/AllTabBean.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/ImageResultBean.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/UploadResultBean.dart';
import 'package:example_flutter/HomeModel/util/ParseUtil.dart';
import 'package:example_flutter/commonModel/GMBase.dart';
import 'package:example_flutter/commonModel/picker/base/BasePickerComponent.dart';
import 'package:example_flutter/commonModel/toast/toast.dart';
import 'package:example_flutter/commonModel/util/ImageUtil.dart';
import 'package:example_flutter/res/GMRes.dart';
import 'package:flutter/material.dart';
import 'package:flutter_animation_set/animator.dart';

class WorkModel extends BaseModel {
  LiveData<bool> rectMaskLive = new LiveData();
  LiveData<String> maskTabLive = new LiveData();
  LiveData<PointItem> pointLive = new LiveData();
  LiveData<List<int>> nowIndexLive = new LiveData();
  LiveData<Map<String, List<List<String>>>> selectLive = new LiveData();
  LiveData<Map<String, List<List<String>>>> tabLive = new LiveData();
  LiveData<bool> needHelpLineLive=new LiveData();

  Map<String, List<List<String>>> selectMap = new Map();
  Map<String, List<List<String>>> fixDataMap = new Map();
  HomeRepo _repo = HomeRepo.getInstance();
  PointItem pointItem = new PointItem();

  AllTabBean allTabBean;
  int imageId;
  int currentIndex;
  bool needHelpLine = true;

  WorkModel(this.imageId, this.currentIndex);

  getImageResutl(BuildContext context, bool showPicker) {
    if (showPicker) {
      BaseCenterPicker()
        ..setPicker(BaseLoadingItem("加载中..."))
        ..show(context);
    }
    _repo.imageAi("${imageId}").listen((value) {
      selectMap.clear();
      selectMap.addAll(ParseUtil.parseSelect(value));
      selectLive.notifyView(selectMap);
      if (showPicker) {
        Navigator.pop(context);
      }
    }).onError((error) {
      Toast.show(context, error.toString());
      print(error.toString());
      Toast.show(context, "这个照片估计识别不出来 导致出错");
      if (showPicker) {
        Navigator.pop(context);
      }
    });
  }

  allTab(BuildContext context, bool showPicker) {
    if (showPicker) {
      BaseCenterPicker()
        ..setPicker(BaseLoadingItem("加载中"))
        ..show(context);
    }
    nowIndexLive.notifyView([_repo.currentPage, currentIndex + 1]);
    HomeRepo.getInstance().getAllTab().listen((value) {
      allTabBean = value;
      fixDataMap.clear();
      fixDataMap.addAll(ParseUtil.changTabToList(allTabBean));
      tabLive.notifyView(fixDataMap);
      if (showPicker) {
        Navigator.pop(context);
      }
    }).onError((error) {
      Toast.show(context, error.toString());
      print(error.toString());
      if (showPicker) {
        Navigator.pop(context);
      }
    });
  }

  @override
  void dispose() {
    needHelpLineLive.dispost();
    rectMaskLive.dispost();
    maskTabLive.dispost();
    pointLive.dispost();
    nowIndexLive.dispost();
    tabLive.dispost();
    selectLive.dispost();
  }

  void selectItem(String key, String title, String result) {
    List<List<String>> innlist = selectMap[key];
    if (innlist == null || innlist.isEmpty) {
      selectMap[key] = [
        [title, result]
      ];
    } else {
      int index = -1;
      for (int i = 0; i < innlist.length; i++) {
        if (innlist[i][0] == title) {
          index = i;
          break;
        }
      }
      if (index != -1) {
        innlist[index][1] = result;
      } else {
        List<String> list = [title, result];
        innlist.add(list);
      }
    }
    selectLive.notifyView(selectMap);
  }

  void deleteSelectItem(BuildContext context, String key, String title) {
    BaseCenterPicker()
      ..setPicker(SurePicker("确定删除这个条目吗？", () {
        Navigator.pop(context);
      }, () {
        Navigator.pop(context);
        var selectList = selectMap[key];
        if (selectList != null && selectList.isNotEmpty) {
          if (selectList.length == 1) {
            selectMap.remove(key);
          } else {
            int index = -1;
            for (int i = 0; i < selectList.length; i++) {
              if (selectList[i][0] == title) {
                index = i;
              }
            }
            if (index != -1) {
              selectList.removeAt(index);
            }
          }
        }
        selectLive.notifyView(selectMap);
      }))
      ..show(context);
  }

  void imageNext(BuildContext context) {
    if (currentIndex == 8) {
      _repo.getImageResult(_repo.currentPage + 1, 9).listen((data) {
        if (data == null || data.picList == null || data.picList.isEmpty) {
          Toast.show(context, "已经是最后一张了哦～");
        } else {
          currentIndex = 0;
          _repo.currentPage = _repo.currentPage + 1;
          _repo.updateCurrentPageList(data.picList);
          getNetWorkImg(context);
          imageId = _repo.getCurrentPageList()[currentIndex].id;
          nowIndexLive.notifyView([_repo.currentPage, currentIndex + 1]);
          selectLive.notifyView(null);
          getImageResutl(context, false);
        }
      }).onError((error) {
        Toast.show(context, error.toString());
        print(error.toString());
      });
    } else {
      if (currentIndex + 1 > _repo.getCurrentPageList().length - 1) {
        Toast.show(context, "已经是最后一张了哦～");
        return;
      }
      currentIndex = currentIndex + 1;
      getNetWorkImg(context);
      imageId = _repo.getCurrentPageList()[currentIndex].id;
      selectLive.notifyView(null);
      getImageResutl(context, false);
      nowIndexLive.notifyView([_repo.currentPage, currentIndex + 1]);
    }
  }

  void imageBefore(BuildContext context) {
    if (currentIndex == 0) {
      if (_repo.currentPage == 1) {
        Toast.show(context, "已经是第一张了哦～");
        return;
      }
      _repo.currentPage = _repo.currentPage - 1;
      _repo.getImageResult(_repo.currentPage, 9).listen((data) {
        currentIndex = 8;
        _repo.updateCurrentPageList(data.picList);
        getNetWorkImg(context);
        imageId = _repo.getCurrentPageList()[currentIndex].id;
        selectLive.notifyView(null);
        getImageResutl(context, false);
        nowIndexLive.notifyView([_repo.currentPage, currentIndex + 1]);
      }).onError((error) {
        Toast.show(context, error.toString());
        print(error.toString());
      });
    } else {
      currentIndex = currentIndex - 1;
      getNetWorkImg(context);
      imageId = _repo.getCurrentPageList()[currentIndex].id;
      selectLive.notifyView(null);
      getImageResutl(context, false);
      nowIndexLive.notifyView([_repo.currentPage, currentIndex + 1]);
    }
  }

  void save(BuildContext context, bool param1) {
    BaseCenterPicker()
      ..setPicker(BaseLoadingItem("保存中..."))
      ..show(context);
    StringBuffer stringBuffer = new StringBuffer();
    stringBuffer.write("""
    {"face_details":{
    """);
    List<List<String>> finalResult = new List();
    selectMap.forEach((key, value) {
      for (int i = 0; i < value.length; i++) {
        String before;
        EXPLAN.forEach((k, v) {
          if (v == value[i][0]) {
            before = k;
          }
        });
        finalResult.add([before, value[i][1]]);
      }
    });
    for (int i = 0; i < finalResult.length; i++) {
      stringBuffer.write("""
        "${finalResult[i][0]}":"${finalResult[i][1]}"
      """);
      if (i != finalResult.length - 1) {
        stringBuffer.write(",");
      }
    }
    stringBuffer.write("}}");
    print("====>  ${stringBuffer.toString()}");
    _repo.saveImageResult(imageId, stringBuffer.toString()).listen((value) {
      if (value != null) {
        Navigator.pop(context);
        imageNext(context);
//        Navigator.pop(context, -1);
        Toast.show(context, "保存成功");
      }
    }).onError((error) {
      Toast.show(context, error.toString());
      print(error.toString());
      Navigator.pop(context);
    });
  }

  void saveDrawImage(
      BuildContext context, double picScare, double topBuf, double topAdd) {
    if (maskTabLive.data == null) {
      Toast.show(context, "得选着一个标签哦");
      return;
    }
    print("SCARE =====  >>>>> $picScare");
    if (pointItem.list.isEmpty) {
      Toast.show(context, "还没有标记数据哦～");
      return;
    }
    BaseCenterPicker()
      ..setPicker(BaseLoadingItem("保存中..."))
      ..show(context);
    List<int> uploadList = [];
    pointItem.list.forEach((off) {
      uploadList.add((off.dx * picScare).toInt());
      print("TOPPPP AADD  ${topAdd}  ${topBuf}");
      if (topAdd < 0) {
        uploadList.add(((off.dy - topAdd) * picScare).toInt());
      } else {
        uploadList.add(((off.dy - topBuf) * picScare).toInt());
      }
    });
    if (uploadList.isNotEmpty) {
      getTempDirX(context, (dir) {
        var savePath = "${dir}/${DateTime.now().millisecondsSinceEpoch}.jpeg";
        DioUtil()
            .getDio()
            .download(_repo.getCurrentPageList()[currentIndex].picurl, savePath)
            .whenComplete(() {
          String uploadPath =
              "${dir}/sign${DateTime.now().millisecondsSinceEpoch}.jpeg";
          toImage(uploadList, uploadPath, savePath).whenComplete(() {

//            HomeRepo.getInstance()
//                .maskImage(uploadPath, imageId, maskExplain[maskTabLive.data],
//                    listToUi(pointItem.list))
//                .listen((value) {
//              if (value != null) {
//                Toast.show(context, "保存成功");
//                Navigator.pop(context);
//                File(uploadPath).delete();
//                Navigator.pop(context);
//              }
//            }).onError((error) {
//              Toast.show(context, error.toString());
//              print(error.toString());
//              Navigator.pop(context);
//            });

            //TODO HERE  WWWWw
            String realSavePath =
                "${dir}/mask${DateTime.now().millisecondsSinceEpoch}.png";
            _repo.uploadMyImage(uploadPath, "${imageId}").listen((value){
              _repo.downloadMyImage(realSavePath,value.fileId,(){
                print("UPLOAD MY OKKKKK");
//                toImageTest(uploadList, "${dir}/test${DateTime.now().millisecondsSinceEpoch}.jpeg",savePath ).whenComplete((){});
                File(savePath).delete();
                File(uploadPath).delete();
//                Timer(Duration(seconds: 2),(){
                  HomeRepo.getInstance()
                      .maskImage(
                      realSavePath, "${imageId}", maskExplain[maskTabLive.data],
                      listToUi(pointItem.list),0)
                      .listen((value) {
                    if (value != null) {
                      Toast.show(context, "保存成功");
                      Navigator.pop(context);
//                      Navigator.pop(context);
                      imageNext(context);
                    }
                  }).onError((error) {
                    Toast.show(context, error.toString());
                    print(error.toString());
                    Navigator.pop(context);
                  });
//                });

              });
            }).onError((error){
              Toast.show(context, error.toString());
              print(error.toString());
              Navigator.pop(context);
            });


          }).catchError((error) {
            Navigator.pop(context);
            Toast.show(context, "保存失败");
            print(error.toString());
          });
        });
      });
    }
  }

  void saveImage(BuildContext context) {
    Toast.show(context, "开始保存");
    getTempDir().then((value) {
      if (value != null) {
        print(value);
        var savePath = "${value}/${DateTime.now().millisecondsSinceEpoch}.jpeg";
        DioUtil()
            .getDio()
            .download(_repo.getCurrentPageList()[currentIndex].picurl, savePath,
                onReceiveProgress: (int count, int total) {
          //进度
//          Toast.show(context, "进度！！ $count $total");
          print("进度！！ $count $total");
        }).then((value) {
          Toast.show(context, "下载完成");
          print("OKKK  " + savePath);
          openCachce();
        }).catchError((error) {
          Toast.show(context, error.toString());
          print(error.toString());
        });
      }
    });
  }

  void syncPos(double dx, double dy) {
    pointItem.setX(dx);
    pointItem.setY(dy);
    pointLive.notifyView(pointItem);
  }

  void getNetWorkImg(BuildContext context) {
    rectMaskLive.notifyView(pointItem.rectModel);
    loadNetWorkImage(_repo.getCurrentPageList()[currentIndex].picurl)
        .then((value) {
      pointItem.reset();
      pointItem.setImage(value);
      pointLive.notifyView(pointItem);
    }).catchError((error) {
      Toast.show(context, error.toString());
      print(error.toString());
    });
  }

  void syncPoint() {
    pointLive.notifyView(pointItem);
  }

  void showMaskTabSelect(BuildContext context) {
    showModalBottomSheet(
        context: context,
        builder: (BuildContext context) {
          List<Widget> list = new List();
          maskTabList.forEach((value) {
            list.add(new ListTile(
              leading: new Icon(Icons.select_all),
              title: new Text(value),
              onTap: () async {
                Navigator.pop(context);
                maskTabLive.notifyView(value);
              },
            ));
          });
          return new Column(mainAxisSize: MainAxisSize.min, children: list);
        });
  }

  void getMaskedImage(BuildContext context) {
    if (maskTabLive.data == null) {
      Toast.show(context, "还没有选中标签哦～");
      return;
    }
    BaseCenterPicker()
      ..setPicker(BaseLoadingItem("加载中..."))
      ..show(context);
    HomeRepo.getInstance()
        .getMaskInfo("${imageId}", maskExplain[maskTabLive.data],0)
        .listen((value) {
          print(value.picurl);
      if (value != null && value.ui != null && value.ui.isNotEmpty) {
        pointItem.list = uiToList(value.ui);
        pointItem.drawPath = true;
        syncPoint();
      }
      Navigator.pop(context);
    }).onError((error) {
      Toast.show(context, error.toString());
      print(error.toString());
      Navigator.pop(context);
    });
  }

  void needHelpLineNotify(bool value) {
    needHelpLine=value;
    needHelpLineLive.notifyView(needHelpLine);
    syncPos(-10, -10);
  }
}
