/*
 * @author lsy
 * @date   2019-11-08
 **/

import 'dart:ui' as ui;
import 'package:example_flutter/HomeModel/base/BaseTitle.dart';
import 'package:example_flutter/HomeModel/base/bean/PointItem.dart';
import 'package:example_flutter/HomeModel/base/view/WorkView.dart';
import 'package:example_flutter/HomeModel/page/work/WorkModel.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/AllTabBean.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/ImageResultBean.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/UploadResultBean.dart';
import 'package:example_flutter/commonModel/GMBase.dart';
import 'package:example_flutter/commonModel/base/BaseState.dart';
import 'package:example_flutter/commonModel/base/MySeparator.dart';
import 'package:example_flutter/commonModel/cache/CacheManager.dart';
import 'package:example_flutter/commonModel/dragScare/flutter_drag_scale.dart';
import 'package:example_flutter/commonModel/toast/toast.dart';
import 'package:example_flutter/res/GMRes.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:flutter_svg/svg.dart';

class WorkPage extends StatefulWidget {
  final String url;
  final int id;
  final int currentIndex;

  WorkPage(this.url, this.id, this.currentIndex);

  @override
  State<StatefulWidget> createState() => WorkState(url, id, currentIndex);
}

class WorkState extends BaseState<WorkPage> {
  WorkModel _model;
  Size screenSize;
  double tabItemHeight;
  double tabHeadHeight;
  double rightAllWidth;
  double rightTitleHeight;
  double picScareSize;
  double topBuf;
  double topAdd;
  final String url;
  double dragStartX, dragStartY, startTranX, startTranY;
  double tapStartX, tapStartY;
  bool dragMask;
  WorkView workItem;

  WorkState(this.url, int id, int currentIndex) {
    _model = new WorkModel(id, currentIndex);
  }


  @override
  void initState() {
    super.initState();
    _model.allTab(context, false);
    _model.getImageResutl(context, false);
    _model.getNetWorkImg(context);
  }

  @override
  void dispose() {
    _model.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    screenSize = MediaQuery.of(context).size;
    tabItemHeight = 30;
    rightAllWidth = 238;
    rightTitleHeight = 15;
    String userName =
        CacheManager.getInstance().get(MEMORY_CACHE).get("userName");
    return Scaffold(
      appBar: MyAppBar(),
      body: Row(
        children: <Widget>[
          mainView(),
          divide(),
          leftItem(),
          divide(),
          centerItem(),
          divide(),
          rightItem()
        ],
      ),
    );
  }

  Widget mainView() {
    return Expanded(
        child: Stack(
      alignment: AlignmentDirectional.bottomCenter,
      children: <Widget>[
        Container(
            width: double.maxFinite,
            height: double.maxFinite,
            color: Colors.black54,
            child: Listener(
              onPointerDown: (down) {
                print("onPointerDownEvent");
              },
              onPointerMove: (move) {
                print("onPointerMove");
              },
              onPointerUp: (up) {
                print("onPointerUp");
              },
              onPointerHover: (hover) {
                if(_model.needHelpLine){
                  _model.syncPos(
                      hover.position.dx, hover.position.dy - kToolbarHeight);
                }
              },
              onPointerExit: (exit) {
                print("onPointerExit");
              },
              onPointerCancel: (cancle) {
                print("onPointerCancel");
              },
              onPointerEnter: (enter) {
                print("onPointerEnter");
              },
            )),
        StreamBuilder<PointItem>(
          stream: _model.pointLive.stream,
          initialData: _model.pointLive.data,
          builder: (con, data) {
            if (data.data == null) {
              return Container();
            }
            workItem = WorkView(_model.pointItem, (scareSize, top, topA) {
              picScareSize = scareSize;
              topBuf = top;
              topAdd = topA;
            });
            return GestureDetector(
                onVerticalDragDown: (details) {
//                        print(
//                            "DOWN  ${details.localPosition.dx} ${details.localPosition.dy}"
//                            "  ${_model.pointItem.getX()}  ${_model.pointItem.getY()}"
//                            "   ${tapStartX}  ${tapStartY}");
                  startTranX = _model.pointItem.tranX;
                  startTranY = _model.pointItem.tranY;
                  dragStartX = details.localPosition.dx;
                  dragStartY = details.localPosition.dy;
                },
                onVerticalDragEnd: (details) {
                  _model.pointItem.dragEnd(details);
                },
                onVerticalDragUpdate: (details) {
                  _model.pointItem.drag(details, startTranX, dragStartX,
                      startTranY, dragStartY, dragMask);
                  _model.syncPoint();
                },
                onTap: () {
                  _model.pointItem.addPoint(tapStartX, tapStartY);
                  _model.syncPoint();
                },
                onTapDown: (details) {
                  tapStartX = details.localPosition.dx;
                  tapStartY = details.localPosition.dy;
                  dragMask = workItem.calutePath(Offset(tapStartX, tapStartY));
                  _model.pointItem.down(tapStartX, tapStartY, dragMask);
                  print("gesture onTap down");
                },
//                      onDoubleTap: () {
//                        if (_model.pointItem.scareSize == 1) {
//                          _model.pointItem.setScareSize(3);
//                          _model.pointItem.setTranX(_model.pointItem.getX());
//                          _model.pointItem.setTranY(_model.pointItem.getY());
//                          _model.syncPoint();
//                        } else {
//                          _model.pointItem.setScareSize(1);
//                          _model.pointItem.setTranX(0);
//                          _model.pointItem.setTranY(0);
//                          _model.syncPoint();
//                        }
//                      },
                child: ClipRect(
                    child: Container(
                  width: double.maxFinite,
                  height: double.maxFinite,
                  child: CustomPaint(painter: workItem),
                )));
          },
        ),
//        Container(
//          width: double.maxFinite,
//          height: double.maxFinite,
//          alignment: Alignment.topCenter,
//          child: Container(
//              width: double.maxFinite,
//              height: 50,
//              color: Colors.black54,
//              child: Row(
//                children: <Widget>[],
//              )),
//        ),
        Container(
          width: double.maxFinite,
          height: 50,
          color: Colors.black54,
        ),
        StreamBuilder<List<int>>(
          stream: _model.nowIndexLive.stream,
          initialData: _model.nowIndexLive.data,
          builder: (con, data) {
            if (data.data == null) {
              return loadingItem();
            }
            return Container(
              height: 50,
              alignment: Alignment.center,
              child: baseText(
                  "第${data.data[0]}页 第${data.data[1]}张", 15, Colors.white),
            );
          },
        ),
        Positioned(
          left: 0,
          bottom: 0,
          child: FlatButton(
            onPressed: () {
              BaseCenterPicker()
                ..setPicker(SurePicker("还没有保存哦 确定上一张吗?", () {
                  Navigator.pop(context);
                }, () {
                  Navigator.pop(context);
                  _model.imageBefore(context);
                }))
                ..show(context);
            },
            child: Container(
              width: 50,
              height: 30,
              alignment: Alignment.centerLeft,
              child: baseText("上一张", 15, Colors.white),
            ),
          ),
        ),
        Positioned(
          right: 0,
          bottom: 0,
          child: FlatButton(
            onPressed: () {
              BaseCenterPicker()
                ..setPicker(SurePicker("还没有保存哦 确定下一张吗?", () {
                  Navigator.pop(context);
                }, () {
                  Navigator.pop(context);
                  _model.imageNext(context);
                }))
                ..show(context);
            },
            child: Container(
              width: 50,
              height: 30,
              alignment: Alignment.center,
              child: baseText("下一张", 15, Colors.white),
            ),
          ),
        ),
      ],
    ));
  }

  Widget divide() {
    return Container(
      margin: EdgeInsets.only(left: 2, right: 2),
      color: Colors.black38,
      width: 1,
      height: double.maxFinite,
    );
  }

  leftItem() {
    return Container(
      width: 100,
      height: double.maxFinite,
      child: Column(
        children: <Widget>[
          Container(
            height: 30,
          ),
          Container(
            alignment: Alignment.center,
            width: double.maxFinite,
            child: baseText("辅助线", 13, Colors.black),
          ),
          StreamBuilder<bool>(
            stream: _model.needHelpLineLive.stream,
            initialData: _model.needHelpLineLive.data,
            builder: (con,data){
              bool needHelpLine;
              if(data.data==null||data.data){
                needHelpLine=true;
              }else{
                needHelpLine=false;
              }
              return Switch(
                value: needHelpLine,
                activeColor: Colors.blue,
                onChanged: (value) {
                  _model.needHelpLineNotify(value);
                },
              );
            },
          ),

          Container(
            height: 20,
          ),
          Container(
            height: 80,
            child: StreamBuilder<bool>(
              stream: _model.rectMaskLive.stream,
              initialData: _model.rectMaskLive.data,
              builder: (con, data) {
                if (data.data == null) {
                  return Container();
                }
                return Column(
                  children: <Widget>[

                    Container(
                      child: baseText("点标记&框标记", 15, Colors.black),
                    ),
                    Switch(
                      value: _model.pointItem.rectModel,
                      activeColor: Colors.blue,
                      onChanged: (value) {
                        _model.pointItem.rectModel = value;
                        _model.syncPoint();
                        _model.rectMaskLive.notifyView(value);
                      },
                    ),
                  ],
                );
              },
            ),
          ),
          Container(
            child: baseFlatButtonItem(() {
              _model.showMaskTabSelect(context);
            }, "选取标签"),
          ),
          Container(
            margin: EdgeInsets.only(top: 3, bottom: 20),
            alignment: Alignment.centerLeft,
            width: double.maxFinite,
            child: StreamBuilder(
              stream: _model.maskTabLive.stream,
              initialData: _model.maskTabLive.data,
              builder: (con, data) {
                if (data.data == null) {
                  return baseText("还没有选着标签哦", 12, Colors.black);
                }
                return baseText("选着的标签:${data.data}", 12, Colors.black);
              },
            ),
          ),
          baseFlatButtonItem(() {
            _model.saveImage(context);
          }, "保存图片"),
          baseFlatButtonItem(() {
            _model.pointItem.close();
            _model.syncPoint();
          }, "闭合标记"),
          baseFlatButtonItem(() {
            _model.pointItem.removePoint();
            _model.syncPoint();
          }, "撤销一步"),
          baseFlatButtonItem(() {
            _model.pointItem.reset();
            _model.syncPoint();
          }, "清除所有"),
          baseFlatButtonItem(() {
            if (_model.pointItem.scareSize == 1) {
              _model.pointItem.setScareSize(3);
              _model.pointItem.setTranX(_model.pointItem.getX());
              _model.pointItem.setTranY(_model.pointItem.getY());
              _model.syncPoint();
            } else {
              _model.pointItem.setScareSize(1);
              _model.pointItem.setTranX(0);
              _model.pointItem.setTranY(0);
              _model.syncPoint();
            }
          }, "放大&缩小"),
          baseFlatButtonItem(() {
            _model.getMaskedImage(context);
          }, "获取点标记结果"),
          baseFlatButtonItem(() {
            _model.saveDrawImage(context, picScareSize, topBuf, topAdd);
          }, "保存点标记结果"),
          Expanded(
            child: Container(),
          ),
          baseFlatButtonItem(() {
            Navigator.pop(context,-1);
          }, "返回上一页"),
        ],
      ),
    );
  }

  rightItem() {
    return Container(
        height: double.maxFinite,
        width: rightAllWidth,
        child: StreamBuilder<Map<String, List<List<String>>>>(
          stream: _model.tabLive.stream,
          initialData: _model.tabLive.data,
          builder: (con, data) {
            if (data.data == null || data.data.isEmpty) {
              return Center(child: CircularProgressIndicator());
            }
            tabHeadHeight = 30 + kToolbarHeight;
            double center1 = screenSize.width - rightAllWidth;
            double center2 = screenSize.width - rightAllWidth / 2;
            List<Widget> allList = new List();
            allList.add(tabHead());
            double startHeight = tabHeadHeight;
            data.data.forEach((k, value) {
              startHeight = startHeight + (rightTitleHeight + tabItemHeight);
              allList.add(divideItem(k));
              List<Widget> grids = new List();
              for (int i = 0; i < value.length; i += 2) {
                if (i != 0) {
                  startHeight = startHeight + (tabItemHeight);
                }
                grids.add(glidItem(k, value[i], startHeight, center1));
                if (i + 1 < value.length) {
                  grids.add(glidItem(k, value[i + 1], startHeight, center2));
                }
              }
              int count = (value.length / 2).ceil();
              allList.add(tabItem(tabItemHeight * count, grids));
            });
            return ListView(
              physics: BouncingScrollPhysics(),
              children: allList,
            );
          },
        ));
  }

  tabItem(double height, List<Widget> items) {
    return Container(
      width: rightAllWidth / 2,
      height: height,
      child: GridView.count(
        crossAxisCount: 2,
        childAspectRatio: rightAllWidth / 2 / tabItemHeight,
        children: items,
      ),
    );
  }

  divideItem(String text) {
    return Container(
      alignment: Alignment.center,
      width: double.maxFinite,
      height: rightTitleHeight,
      child: baseText(text, 10, Colors.black54),
    );
  }

  glidItem(String key, List<String> dataList, double top, double left) {
    String title = dataList[0];
    List<PopupMenuItem<String>> list = new List();
    for (int i = 1; i < dataList.length; i++) {
      list.add(PopupMenuItem(
          value: dataList[i],
          child: Container(
            width: rightAllWidth / 4,
            alignment: Alignment.center,
            child: baseText(dataList[i], 12, ALColors.Color666666),
          )));
    }
    return Container(
        padding: EdgeInsets.all(5),
        child: FlatButton(
            color: Color.fromARGB(255, 236, 236, 236),
            shape: RoundedRectangleBorder(
                borderRadius: BorderRadius.all(Radius.circular(5))),
            onPressed: () async {
              final result = await showMenu(
                  context: context,
                  position: RelativeRect.fromLTRB(
                      left, top, left + rightAllWidth / 2, 0),
                  items: list);
              print(result);
              if (result != null) {
                _model.selectItem(key, title, result);
              }
            },
            child: Container(
                width: double.maxFinite,
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: <Widget>[
                    Expanded(
                      child: Container(),
                    ),
                    Container(
                      padding: EdgeInsets.only(right: 5),
                      child: baseText(title, 13, Colors.black),
                    ),
                    Container(
                      width: 5,
                      child: SvgPicture.asset("image/bottom_arrow.svg"),
                    ),
                    Expanded(
                      child: Container(),
                    ),
                  ],
                ))));
  }

  tabHead() {
    return GestureDetector(
        onTap: () => _model.allTab(context, true),
        child: Container(
          padding: EdgeInsets.only(top: 5, left: 16),
          height: 30,
          alignment: Alignment.centerLeft,
          child: Icon(Icons.sync),
        ));
  }

  centerItem() {
    return Container(
        width: 160,
        height: double.maxFinite,
        child: StreamBuilder<Map<String, List<List<String>>>>(
          stream: _model.selectLive.stream,
          initialData: _model.selectLive.data,
          builder: (con, data) {
            if (data.data == null) {
              return Column(
                children: <Widget>[
                  centerTitle(context),
                  Expanded(
                    child: Center(child: CircularProgressIndicator()),
                  )
                ],
              );
            }
            List<Widget> list = new List();
            list.add(centerTitle(context));
            data.data.forEach((k, v) {
              list.add(divideItem(k));
              for (int i = 0; i < v.length; i++) {
                list.add(centerListItem(k, "${v[i][0]}:${v[i][1]}", v[i][0]));
              }
            });
            return ListView(
              physics: BouncingScrollPhysics(),
              children: list,
            );
          },
        ));
  }

  centerListItem(String key, String showText, String title) {
    return Container(
      margin: EdgeInsets.all(5),
      color: Color.fromARGB(255, 236, 236, 236),
      width: double.maxFinite,
      height: 30,
      child: Stack(
        alignment: AlignmentDirectional.center,
        children: <Widget>[
//          Positioned(
//              right: 5,
//              top: 5,
//              child: GestureDetector(
//                onTap: () {
//                  _model.deleteSelectItem(context, key, title);
//                },
//                child: Icon(
//                  Icons.delete,
//                  color: Colors.red,
//                  size: 18,
//                ),
//              )),
          baseText(showText, 13, Colors.black)
        ],
      ),
    );
  }

  Widget centerTitle(BuildContext context) {
    return Container(
      width: double.maxFinite,
      height: 26,
      padding: EdgeInsets.only(top: 5, left: 5),
      alignment: Alignment.centerLeft,
      child: Row(
        children: <Widget>[
          GestureDetector(
              onTap: () {
                BaseCenterPicker()
                  ..setPicker(SurePicker("清除已经选好的数据 重新识别图片吗？", () {
                    Navigator.pop(context);
                  }, () {
                    Navigator.pop(context);
                    _model.getImageResutl(context, true);
                  }))
                  ..show(context);
              },
              child: Icon(Icons.sync)),
          Expanded(
            child: Container(),
          ),
          GestureDetector(
            onTap: () {
              BaseCenterPicker()
                ..setPicker(SurePicker("确定保存吗?", () {
                  Navigator.pop(context);
                }, () {
                  Navigator.pop(context);
                  _model.save(context, true);
                }))
                ..show(context);
            },
            child: Container(
              decoration: BoxDecoration(
                  color: Colors.red,
                  borderRadius: BorderRadius.all(Radius.circular(2))),
              alignment: Alignment.center,
              height: double.maxFinite,
              width: 50,
              margin: EdgeInsets.only(right: 5),
              child: baseText("保存", 13, Colors.white),
            ),
          )
        ],
      ),
    );
  }
}
