/*
 * @author lsy
 * @date   2019-11-07
 **/
import 'dart:convert';
import 'dart:io';
import 'dart:typed_data';

import 'package:dio/dio.dart';
import 'package:example_flutter/HomeModel/base/test/HomeTest.dart';
import 'package:example_flutter/HomeModel/page/work/temp.dart';
import 'package:example_flutter/HomeModel/service/remote/api/HomeApi.serv.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/AllTabBean.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/DeleteResultBean.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/DetectImgBean.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/ImageAiBean.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/ImageResultBean.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/MaskResultBean.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/PutImageDataBean.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/TotalImageBean.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/UploadBean.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/UploadMyImageBean.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/UploadResultBean.dart';
import 'package:example_flutter/commonModel/GMBase.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter_animation_set/animator.dart';
import 'package:rxdart/rxdart.dart';

class HomeRepo {
  Dio mydio;

  static HomeRepo _repo;

  HomeRepo._() {
    mydio = Dio(getw());
  }

  static HomeRepo getInstance() {
    if (_repo == null) {
      _repo = new HomeRepo._();
    }
    return _repo;
  }

  int currentPage = 1;

  Observable<AllTabBean> getAllTab() {
    return HomeApiImpl().getAllTab();
  }

  List<UploadResultBean> scanList = new List();

  void updateScanList(List<UploadResultBean> newList) {
    this.scanList = newList;
  }

  Observable<ImageResultBean> getImageResult(
      int currentPage, int onePageCount) {
    return HomeApiImpl().getImageList(currentPage, 9);
//    return Observable.fromFuture(compute(paseImageResult, TEST_IMAGES));
  }

  List<PicList> currentList = new List();

  void updateCurrentPageList(List<PicList> picList) {
    if (picList != null && picList.isNotEmpty) {
      currentList.clear();
      currentList.addAll(picList);
    }
  }

  List<PicList> getCurrentPageList() {
    return currentList;
  }

  Observable<ImageAiBean> imageAi(String id) {
    return Observable.fromFuture(DioUtil().get('images/${id}/'))
        .flatMap((value) {
      if (value != null &&
          (value.statusCode >= 200 && value.statusCode < 300)) {
        return Observable.fromFuture(compute(paseImageAi, value.toString()));
      } else {
        return Observable.fromFuture(null);
      }
    });
  }

  Observable<PutImageDataBean> saveImageResult(int id, String jsonResult) {
    return Observable.fromFuture(DioUtil.getInstance()
            .getDio()
            .put('images/${id}/', data: jsonResult))
        .flatMap((value) {
      if (value != null &&
          (value.statusCode >= 200 && value.statusCode < 300)) {
        return Observable.fromFuture(
            compute(parsePutImageBean, value.toString()));
      } else {
        return Observable.fromFuture(null);
      }
    });
  }

  Observable<MaskResultBean> maskImage(
      String path, String id, String tag, String ui,int tagged) {
    var name = path.substring(path.lastIndexOf("/") + 1, path.length);
    FormData formData = new FormData.from({
      "file": new UploadFileInfo(new File(path), name),
      "tag": tag,
      "ui": ui,
      "tagged":"${tagged}"
    });
    return Observable.fromFuture(DioUtil.getInstance()
            .getDio()
            .post('maskimages/${id}/', data: formData))
        .flatMap((value) {
      if (value != null &&
          (value.statusCode >= 200 && value.statusCode < 300)) {
        return Observable.fromFuture(
            compute(parseMaskResult, value.toString()));
      } else {
        return Observable.fromFuture(null);
      }
    });
  }

  Observable<MaskResultBean> getMaskInfo(String id, String tag,int tagged) {
    return Observable.fromFuture(DioUtil.getInstance()
            .getDio()
            .get('maskimages/${id}/', queryParameters: {"tag": tag,"tagged":tagged}))
        .flatMap((value) {
      if (value != null &&
          (value.statusCode >= 200 && value.statusCode < 300)) {
        return Observable.fromFuture(
            compute(parseMaskResult, value.toString()));
      } else {
        return Observable.fromFuture(null);
      }
    });
  }

  Observable<DeleteResultBean> deleteItem(int id) {
    return Observable.fromFuture(
            DioUtil.getInstance().getDio().delete("images/${id}/"))
        .flatMap((value) {
      if (value != null &&
          (value.statusCode >= 200 && value.statusCode < 300)) {
        return Observable.fromFuture(
            compute(parseDeleteResult, value.toString()));
      } else {
        return Observable.fromFuture(null);
      }
    });
  }

  Observable<TotalImageBean> getTotalImage() {
    return HomeApiImpl().getTotalImages();
  }

  void downloadMyImage(String path, String id, Function() ok) {
    mydio
        .download("api/downfile", path,
            options: Options(method: "POST"), data: FormData.from({"id": id}))
        .then((value) {
    }).whenComplete(() {
      ok();
    });
//    Observable.fromFuture(dio
//        .post('', data:FormData.from( {"id":id})))
//        .listen((value) {
//
//      if (value != null &&
//          (value.statusCode >= 200 && value.statusCode < 300)) {
//
////        HttpClientResponse resp = ;
////        final Uint8List bytes =  consolidateHttpClientResponseBytes(resp) as Uint8List;
//        File(path).writeAsStringSync(value.data.toString() );
//        ok();
//      }
//    });
  }

  Observable<UploadMyImageBean> uploadMyImage(String path, String id) {
    var name = path.substring(path.lastIndexOf("/") + 1, path.length);
    FormData formData = new FormData.from({
      "file": new UploadFileInfo(new File(path), name),
      "id": id,
    });
    return Observable.fromFuture(mydio.post('api/fileUpload', data: formData))
        .flatMap((value) {
      if (value != null &&
          (value.statusCode >= 200 && value.statusCode < 300)) {
        return Observable.fromFuture(compute(parseMyUpload, value.toString()));
      } else {
        return Observable.fromFuture(null);
      }
    });
  }

  BaseOptions getw() {
    BaseOptions options = BaseOptions();
    options.connectTimeout = 10 * 1000;
    options.receiveTimeout = 20 * 1000;
//    options.contentType = ContentType.parse('application/x-www-form-urlencoded');
//    options.contentType = ContentType.json;
    options.responseType = ResponseType.plain;
    options.baseUrl = "http://114.67.74.194:8888/";
    Map<String, dynamic> headers = Map<String, dynamic>();
    headers['Accept'] = 'application/json';
    headers['version'] = '1.0.0';
    options.headers = headers;
    return options;
  }

  Observable<DetectImgBean> detectImg(int id) {
    return Observable.fromFuture(DioUtil().getDio().put("filtimage/${id}/"))
        .flatMap((value) {
      if (value != null &&
          (value.statusCode >= 200 && value.statusCode < 300)) {
        return Observable.fromFuture(compute(detectImgBean, value.toString()));
      } else {
        return Observable.fromFuture(null);
      }
    });
  }

  Observable<UploadBean> uploadImg(String path) {
    return Observable.fromFuture(
            DioUtil.getInstance().uploadFile("image-upload/", path))
        .flatMap((value) {
      if (value != null &&
          (value.statusCode >= 200 && value.statusCode < 300)) {
        return Observable.fromFuture(compute(parseUpload, value.toString()));
      } else {
        return Observable.fromFuture(null);
      }
    });
  }

  final int checkPageSize = 9;
  int nowCheckPageIndex = 1;
  List<PicList> checkList = [];

  Observable<ImageResultBean> getCheckList(int currentPage) {
    return HomeApiImpl().getCheckList(currentPage, checkPageSize);
//    return Observable.fromFuture(
//        Future.value(paseImageResultBean(checkListText)));
  }

  int nowCheckMaskPageIndex = 1;
  List<PicList> checkMaskList = [];

  Observable<ImageResultBean> getCheckMaskList(int currentPage) {
    return HomeApiImpl().getCheckMaskList(currentPage, checkPageSize,"0");
//    return Observable.fromFuture(
//        Future.value(paseImageResultBean(checkListText)));
  }

  void updateCheckList(List<PicList> picList) {
    if (picList != null && picList.isNotEmpty) {
      checkList.clear();
      checkList.addAll(picList);
    }
  }

  void updateCheckMaskList(List<PicList> picList) {
    if (picList != null && picList.isNotEmpty) {
      checkMaskList.clear();
      checkMaskList.addAll(picList);
    }
  }

  Observable<ImageAiBean> getCheckImageDetail(String id) {
    return Observable.fromFuture(
            DioUtil().getDio().get("checkimagedetail/${id}"))
        .flatMap((value) {
      if (value != null &&
          (value.statusCode >= 200 && value.statusCode < 300)) {
        return Observable.fromFuture(compute(paseImageAi, value.toString()));
      } else {
        return Observable.fromFuture(null);
      }
    });
//    return Observable.fromFuture(
//        Future.value(ImageAiBean.fromJson(json.decode(checkDetail))));
  }

  Observable<PutImageDataBean> saveCheckResult(String id, String jsonResult) {
    return Observable.fromFuture(DioUtil.getInstance()
            .getDio()
            .put('checkimagedetail/${id}/', data: jsonResult))
        .flatMap((value) {
      if (value != null &&
          (value.statusCode >= 200 && value.statusCode < 300)) {
        return Observable.fromFuture(
            compute(parsePutImageBean, value.toString()));
      } else {
        return Observable.fromFuture(null);
      }
    });
  }
}

UploadBean parseUpload(String value) {
  return UploadBean.fromJson(json.decode(value));
}

DetectImgBean detectImgBean(String value) {
  return DetectImgBean.fromJson(json.decode(value));
}

ImageAiBean paseImageAi(String value) {
  return ImageAiBean.fromJson(json.decode(value));
}

DeleteResultBean parseDeleteResult(String value) {
  return DeleteResultBean.fromJson(json.decode(value));
}

PutImageDataBean parsePutImageBean(String value) {
  return PutImageDataBean.fromJson(json.decode(value));
}

MaskResultBean parseMaskResult(String value) {
  return MaskResultBean.fromJson(json.decode(value));
}

UploadMyImageBean parseMyUpload(String value) {
  return UploadMyImageBean.fromJson(json.decode(value));
}
