/*
 * @author lsy
 * @date   2019-11-07
 **/
import 'package:example_flutter/Annotations/anno/Get.dart';
import 'package:example_flutter/Annotations/anno/Post.dart';
import 'package:example_flutter/Annotations/anno/Query.dart';
import 'package:example_flutter/Annotations/anno/ServiceCenter.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/AllTabBean.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/ImageResultBean.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/TotalImageBean.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/UploadResultBean.dart';

@ServiceCenter()
abstract class HomeApi{

  @Get("anno-meta/")
  AllTabBean getAllTab();

  @Post("image-upload/")
  UploadResultBean upload(Map upload);

  @Get("imagelist/")
  ImageResultBean getImageList(@Query("page")int page,@Query("pageSize")int pageSize);

  @Get("countimage/")
  TotalImageBean getTotalImages();

  @Get("checkimagelist/")
  ImageResultBean getCheckList(@Query("page")int page,@Query("pageSize")int pageSize);

  @Get("checkmasklist/")
  ImageResultBean getCheckMaskList(@Query("page")int page,@Query("pageSize")int pageSize,@Query("tagged")String tagged);

}