/*
 * @author lsy
 * @date   2019-11-14
 **/
class ImageResultBean {
  List<PicList> picList;

  ImageResultBean({this.picList});

  ImageResultBean.fromJson(Map<String, dynamic> json) {
    if (json['pic_list'] != null) {
      picList = new List<PicList>();
      json['pic_list'].forEach((v) {
        picList.add(new PicList.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.picList != null) {
      data['pic_list'] = this.picList.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class PicList {
  String picurl;
  int id;
  String status;

  PicList({this.picurl, this.id, this.status});

  PicList.fromJson(Map<String, dynamic> json) {
    picurl = json['picurl'];
    id = json['id'];
    status = json['status'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['picurl'] = this.picurl;
    data['id'] = this.id;
    data['status'] = this.status;
    return data;
  }
}

