/*
 * @author lsy
 * @date   2019-12-09
 **/
import 'package:example_flutter/HomeModel/page/work/temp.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/AllTabBean.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/ImageAiBean.dart';

class ParseUtil {
  static Map<String, List<List<String>>> changTabToList(AllTabBean allTabBean) {
    Map<String, List<List<String>>> fixDataMap = new Map();
    //=====眉毛
    List<List<String>> browList = new List();

    List<String> eyebrowStyle = new List();
    eyebrowStyle.add(allTabBean.eyebrowstyle.name);
    eyebrowStyle.add(allTabBean.eyebrowstyle.eyebrowstyleData.willow);
    eyebrowStyle.add(allTabBean.eyebrowstyle.eyebrowstyleData.wild);

    List<String> eyebrowthickStyle = new List();
    eyebrowthickStyle.add(allTabBean.eyebrowthickness.name);
    eyebrowthickStyle
        .add(allTabBean.eyebrowthickness.eyebrowthicknessData.cumei);
    eyebrowthickStyle
        .add(allTabBean.eyebrowthickness.eyebrowthicknessData.biaozhunmei);
    eyebrowthickStyle
        .add(allTabBean.eyebrowthickness.eyebrowthicknessData.xiemei);

    List<String> concen = new List();
    concen.add(allTabBean.eyebrowsconcentration.name);
    concen.add(
        allTabBean.eyebrowsconcentration.eyebrowsconcentrationData.piandan);
    concen.add(
        allTabBean.eyebrowsconcentration.eyebrowsconcentrationData.feichandan);
    concen.add(allTabBean
        .eyebrowsconcentration.eyebrowsconcentrationData.nongduzhenghao);

    List<String> concenf = new List();
    concenf.add(allTabBean.eyebrowsconcentrationF.name);
    concenf.add(allTabBean
        .eyebrowsconcentrationF.eyebrowsconcentrationFData.fenbujunyun);
    concenf.add(allTabBean
        .eyebrowsconcentrationF.eyebrowsconcentrationFData.qianshuhoumi);
    concenf.add(allTabBean
        .eyebrowsconcentrationF.eyebrowsconcentrationFData.qianmuhoushu);
    concenf.add(allTabBean
        .eyebrowsconcentrationF.eyebrowsconcentrationFData.lianjunyun);

    List<String> brow = new List();
    brow.add(allTabBean.brow.name);
    brow.add(allTabBean.brow.browData.wide);
    brow.add(allTabBean.brow.browData.narrow);
    brow.add(allTabBean.brow.browData.appropriate);

    List<String> eyebrow = new List();
    eyebrow.add(allTabBean.eyebow.name);
    eyebrow.add(allTabBean.eyebow.eyebowData.on);
    eyebrow.add(allTabBean.eyebow.eyebowData.standard);
    eyebrow.add(allTabBean.eyebow.eyebowData.one);
    eyebrow.add(allTabBean.eyebow.eyebowData.sagging);

    browList.add(eyebrowStyle);
    browList.add(eyebrowthickStyle);
    browList.add(concen);
    browList.add(concenf);
    browList.add(brow);
    browList.add(eyebrow);

    fixDataMap.putIfAbsent("眉毛部分", () => browList);

    //=====眼睛👀
    List<List<String>> eyeList = new List();

    List<String> lefteye = new List();
    lefteye.add(allTabBean.leftEye.name);
    lefteye.add(allTabBean.leftEye.leftEyeData.seye);
    lefteye.add(allTabBean.leftEye.leftEyeData.eyes);
    lefteye.add(allTabBean.leftEye.leftEyeData.doubleIn);

    List<String> righteye = new List();
    righteye.add(allTabBean.rigthEye.name);
    righteye.add(allTabBean.rigthEye.rigthEyeData.seye);
    righteye.add(allTabBean.rigthEye.rigthEyeData.eyes);
    righteye.add(allTabBean.rigthEye.rigthEyeData.doubleIn);

    List<String> eyebag = new List();
    eyebag.add(allTabBean.eyebag.name);
    eyebag.add(allTabBean.eyebag.eyebagData.yes);
    eyebag.add(allTabBean.eyebag.eyebagData.no);

    List<String> eyeStyleleft = new List();
    eyeStyleleft.add(allTabBean.eyestyleLeft.name);
    eyeStyleleft.add(allTabBean.eyestyleLeft.eyestyleLeftData.almonEyes);
    eyeStyleleft.add(allTabBean.eyestyleLeft.eyestyleLeftData.peach);
    eyeStyleleft.add(allTabBean.eyestyleLeft.eyestyleLeftData.fineCheng);
    eyeStyleleft.add(allTabBean.eyestyleLeft.eyestyleLeftData.deerEye);
    eyeStyleleft.add(allTabBean.eyestyleLeft.eyestyleLeftData.dogEye);

    List<String> eyeStyleright = new List();
    eyeStyleright.add(allTabBean.eyestyleRight.name);
    eyeStyleright.add(allTabBean.eyestyleRight.eyestyleRightData.almonEyes);
    eyeStyleright.add(allTabBean.eyestyleRight.eyestyleRightData.peach);
    eyeStyleright.add(allTabBean.eyestyleRight.eyestyleRightData.fineCheng);
    eyeStyleright.add(allTabBean.eyestyleRight.eyestyleRightData.deerEye);
    eyeStyleright.add(allTabBean.eyestyleRight.eyestyleRightData.dogEye);

    List<String> eyeSpace = new List();
    eyeSpace.add(allTabBean.eyespacing.name);
    eyeSpace.add(allTabBean.eyespacing.eyespacingData.wide);
    eyeSpace.add(allTabBean.eyespacing.eyespacingData.narrow);
    eyeSpace.add(allTabBean.eyespacing.eyespacingData.appropriate);

    List<String> heiyanquan = new List();
    heiyanquan.add(allTabBean.heiyanquanLeft.name);
    heiyanquan.add(allTabBean.heiyanquanLeft.heiyanquanLeftData.yes);
    heiyanquan.add(allTabBean.heiyanquanLeft.heiyanquanLeftData.no);

    List<String> heiyanquanR = new List();
    heiyanquanR.add(allTabBean.heiyanquanRight.name);
    heiyanquanR.add(allTabBean.heiyanquanRight.heiyanquanRightData.yes);
    heiyanquanR.add(allTabBean.heiyanquanRight.heiyanquanRightData.no);

    List<String> wocan = new List();
    wocan.add(allTabBean.wocanLeft.name);
    wocan.add(allTabBean.wocanLeft.wocanLeftData.yes);
    wocan.add(allTabBean.wocanLeft.wocanLeftData.no);

    List<String> wocanR = new List();
    wocanR.add(allTabBean.wocanRight.name);
    wocanR.add(allTabBean.wocanRight.wocanRightData.yes);
    wocanR.add(allTabBean.wocanRight.wocanRightData.no);

    List<String> yanwen = new List();
    yanwen.add(allTabBean.yanwenLeft.name);
    yanwen.add(allTabBean.yanwenLeft.yanwenLeftData.yes);
    yanwen.add(allTabBean.yanwenLeft.yanwenLeftData.no);

    List<String> yanwenR = new List();
    yanwenR.add(allTabBean.yanwenRight.name);
    yanwenR.add(allTabBean.yanwenRight.yanwenRightData.yes);
    yanwenR.add(allTabBean.yanwenRight.yanwenRightData.no);

    List<String> yuweiwen = new List();
    yuweiwen.add(allTabBean.yuweiwenLeft.name);
    yuweiwen.add(allTabBean.yuweiwenLeft.yuweiwenLeftData.yes);
    yuweiwen.add(allTabBean.yuweiwenLeft.yuweiwenLeftData.no);

    List<String> yuweiwenR = new List();
    yuweiwenR.add(allTabBean.yuweiwenRight.name);
    yuweiwenR.add(allTabBean.yuweiwenRight.yuweiwenRightData.yes);
    yuweiwenR.add(allTabBean.yuweiwenRight.yuweiwenRightData.no);

    List<String> yanpao = new List();
    yanpao.add(allTabBean.zhongyanpaoLeft.name);
    yanpao.add(allTabBean.zhongyanpaoLeft.zhongyanpaoLeftData.yes);
    yanpao.add(allTabBean.zhongyanpaoLeft.zhongyanpaoLeftData.no);

    List<String> yanpaoR = new List();
    yanpaoR.add(allTabBean.zhongyanpaoRight.name);
    yanpaoR.add(allTabBean.zhongyanpaoRight.zhongyanpaoRightData.yes);
    yanpaoR.add(allTabBean.zhongyanpaoRight.zhongyanpaoRightData.no);

    List<String> leigou = new List();
    leigou.add(allTabBean.leigouLeft.name);
    leigou.add(allTabBean.leigouLeft.leigouLeftData.yes);
    leigou.add(allTabBean.leigouLeft.leigouLeftData.no);

    List<String> leigouR = new List();
    leigouR.add(allTabBean.leigouRight.name);
    leigouR.add(allTabBean.leigouRight.leigouRightData.yes);
    leigouR.add(allTabBean.leigouRight.leigouRightData.no);

    eyeList.add(lefteye);
    eyeList.add(righteye);
    eyeList.add(eyeStyleleft);
    eyeList.add(eyeStyleright);
    eyeList.add(eyebag);
    eyeList.add(eyeSpace);
    eyeList.add(heiyanquan);
    eyeList.add(heiyanquanR);
    eyeList.add(wocan);
    eyeList.add(wocanR);
    eyeList.add(yanwen);
    eyeList.add(yanwenR);
    eyeList.add(yuweiwen);
    eyeList.add(yuweiwenR);
    eyeList.add(yanpao);
    eyeList.add(yanpaoR);
    eyeList.add(leigou);
    eyeList.add(leigouR);
    fixDataMap.putIfAbsent("眼睛部分", () => eyeList);

    //======== 鼻子👃
    List<List<String>> noseList = new List();

    List<String> nose = new List();
    nose.add(allTabBean.nose.name);
    nose.add(allTabBean.nose.noseData.narrowNose);
    nose.add(allTabBean.nose.noseData.standardNose);
    nose.add(allTabBean.nose.noseData.widepNose);
    nose.add(allTabBean.nose.noseData.wideNose);
    noseList.add(nose);
    fixDataMap.putIfAbsent("鼻子部分", () => noseList);

    //====== 嘴唇👄

    List<List<String>> mouthList = new List();

    List<String> mouth = new List();
    mouth.add(allTabBean.mouth.name);
    mouth.add(allTabBean.mouth.mouthData.standard);
    mouth.add(allTabBean.mouth.mouthData.thick);
    mouth.add(allTabBean.mouth.mouthData.thin);

    List<String> lip = new List();
    lip.add(allTabBean.lip.name);
    lip.add(allTabBean.lip.lipData.yes);
    lip.add(allTabBean.lip.lipData.no);
    lip.add(allTabBean.lip.lipData.notObvious);

    List<String> lipscurved = new List();
    lipscurved.add(allTabBean.lipscurved.name);
    lipscurved.add(allTabBean.lipscurved.lipscurvedData.smile);
    lipscurved.add(allTabBean.lipscurved.lipscurvedData.moderate);
    lipscurved.add(allTabBean.lipscurved.lipscurvedData.attitude);

    List<String> Speciallip = new List();
    Speciallip.add(allTabBean.speciallip.name);
    Speciallip.add(allTabBean.speciallip.speciallipData.cherryLip);
    Speciallip.add(allTabBean.speciallip.speciallipData.supermodelLip);

    mouthList.add(mouth);
    mouthList.add(lip);
    mouthList.add(lipscurved);
    mouthList.add(Speciallip);
    fixDataMap.putIfAbsent("嘴唇部分", () => mouthList);

    //=======其他
    List<List<String>> wrinkList = new List();

    List<String> wrink = new List();
    wrink.add(allTabBean.wrink.name);
    wrink.add(allTabBean.wrink.wrinkData.yes);
    wrink.add(allTabBean.wrink.wrinkData.no);

    wrinkList.add(wrink);
    fixDataMap.putIfAbsent("法令纹", () => wrinkList);

    List<List<String>> checkboneList = new List();

    List<String> checkbone = new List();
    checkbone.add(allTabBean.checkbone.name);
    checkbone.add(allTabBean.checkbone.checkboneData.high);
    checkbone.add(allTabBean.checkbone.checkboneData.flat);
    checkboneList.add(checkbone);
    fixDataMap.putIfAbsent("颧骨部分", () => checkboneList);

    List<List<String>> chinList = new List();
    List<String> chin = new List();
    chin.add(allTabBean.chin.name);
    chin.add(allTabBean.chin.chinData.tip);
    chin.add(allTabBean.chin.chinData.party);
    chin.add(allTabBean.chin.chinData.round);
    chin.add(allTabBean.chin.chinData.ass);
    chinList.add(chin);
    fixDataMap.putIfAbsent("下巴部分", () => chinList);

    List<List<String>> faceList = new List();
    List<String> face = new List();
    face.add(allTabBean.face.name);
    face.add(allTabBean.face.faceData.babyFace);
    face.add(allTabBean.face.faceData.guazilian);
    face.add(allTabBean.face.faceData.fanglian);
    face.add(allTabBean.face.faceData.edanlian);
    face.add(allTabBean.face.faceData.changxinglian);
    face.add(allTabBean.face.faceData.lixinglian);
    face.add(allTabBean.face.faceData.jingzhuan);
    faceList.add(face);
    fixDataMap.putIfAbsent("脸型相关", () => faceList);

    return fixDataMap;
  }

  static Map<String, List<List<String>>> parseSelect(ImageAiBean value) {
    Map<String, List<List<String>>> selectMap = Map();
    List<List<String>> browList = new List();

    if (value.anno.browsStyle != null && value.anno.browsStyle != "无结果") {
      browList.add([EXPLAN["brows_style"], value.anno.browsStyle]);
    }

    if (value.anno.browsThickness != null &&
        value.anno.browsThickness != "无结果") {
      browList.add([EXPLAN["brows_thickness"], value.anno.browsThickness]);
    }

    if (value.anno.dense != null && value.anno.dense != "无结果") {
      browList.add([EXPLAN["Dense"], value.anno.dense]);
    }

    if (value.anno.browDensity != null && value.anno.browDensity != "无结果") {
      browList.add([EXPLAN["brow_density"], value.anno.browDensity]);
    }

    if (value.anno.browsSpacing != null && value.anno.browsSpacing != "无结果") {
      browList.add([EXPLAN["brows_spacing"], value.anno.browsSpacing]);
    }

    if (value.anno.browShape != null && value.anno.browShape != "无结果") {
      browList.add([EXPLAN["brow_shape"], value.anno.browShape]);
    }

    if (browList.isNotEmpty) {
      selectMap.putIfAbsent("眉毛部分", () => browList);
    }

    List<List<String>> eyeList = new List();

    if (value.anno.eyelidLeft != null && value.anno.eyelidLeft != "无结果") {
      eyeList.add([EXPLAN["eyelid_left"], value.anno.eyelidLeft]);
    }

    if (value.anno.eyelidRight != null && value.anno.eyelidRight != "无结果") {
      eyeList.add([EXPLAN["eyelid_right"], value.anno.eyelidRight]);
    }

    if (value.anno.eyeShapeRight != null && value.anno.eyeShapeRight != "无结果") {
      eyeList.add([EXPLAN["eye_shape_right"], value.anno.eyeShapeRight]);
    }

    if (value.anno.eyeShapeLeft != null && value.anno.eyeShapeLeft != "无结果") {
      eyeList.add([EXPLAN["eye_shape_left"], value.anno.eyeShapeLeft]);
    }

    if (value.anno.pouch != null && value.anno.pouch != "无结果") {
      eyeList.add([EXPLAN["pouch"], value.anno.pouch]);
    }

    if (value.anno.eyeDistance != null && value.anno.eyeDistance != "无结果") {
      eyeList.add([EXPLAN["eye_distance"], value.anno.eyeDistance]);
    }

    if (value.anno.heiyanquanLeft != null &&
        value.anno.heiyanquanLeft != "无结果") {
      eyeList.add([EXPLAN["heiyanquan_left"], value.anno.heiyanquanLeft]);
    }

    if (value.anno.wocanLeft != null && value.anno.wocanLeft != "无结果") {
      eyeList.add([EXPLAN["wocan_left"], value.anno.wocanLeft]);
    }
    if (value.anno.yanwenLeft != null && value.anno.yanwenLeft != "无结果") {
      eyeList.add([EXPLAN["yanwen_left"], value.anno.yanwenLeft]);
    }
    if (value.anno.yuweiwenLeft != null && value.anno.yuweiwenLeft != "无结果") {
      eyeList.add([EXPLAN["yuweiwen_left"], value.anno.yuweiwenLeft]);
    }
    if (value.anno.zhongyanpaoLeft != null &&
        value.anno.zhongyanpaoLeft != "无结果") {
      eyeList.add([EXPLAN["zhongyanpao_left"], value.anno.zhongyanpaoLeft]);
    }
    if (value.anno.leigouLeft != null && value.anno.leigouLeft != "无结果") {
      eyeList.add([EXPLAN["leigou_left"], value.anno.leigouLeft]);
    }
    if (value.anno.heiyanquanRight != null &&
        value.anno.heiyanquanRight != "无结果") {
      eyeList.add([EXPLAN["heiyanquan_right"], value.anno.heiyanquanRight]);
    }
    if (value.anno.wocanRight != null && value.anno.wocanRight != "无结果") {
      eyeList.add([EXPLAN["wocan_right"], value.anno.wocanRight]);
    }
    if (value.anno.yanwenRight != null && value.anno.yanwenRight != "无结果") {
      eyeList.add([EXPLAN["yanwen_right"], value.anno.yanwenRight]);
    }
    if (value.anno.yuweiwenRight != null && value.anno.yuweiwenRight != "无结果") {
      eyeList.add([EXPLAN["yuweiwen_right"], value.anno.yuweiwenRight]);
    }
    if (value.anno.zhongyanpaoRight != null &&
        value.anno.zhongyanpaoRight != "无结果") {
      eyeList.add([EXPLAN["zhongyanpao_right"], value.anno.zhongyanpaoRight]);
    }
    if (value.anno.leigouRight != null && value.anno.leigouRight != "无结果") {
      eyeList.add([EXPLAN["leigou_right"], value.anno.leigouRight]);
    }
    if (eyeList.isNotEmpty) {
      selectMap.putIfAbsent("眼睛部分", () => eyeList);
    }

    List<List<String>> noseList = new List();
    if (value.anno.nose != null && value.anno.nose != "无结果") {
      noseList.add([EXPLAN["nose"], value.anno.nose]);
    }
    if (noseList.isNotEmpty) {
      selectMap.putIfAbsent("鼻子部分", () => noseList);
    }

    List<List<String>> lipList = new List();
    if (value.anno.lipThickness != null && value.anno.lipThickness != "无结果") {
      lipList.add([EXPLAN["lip_thickness"], value.anno.lipThickness]);
    }
    if (value.anno.lipPeak != null && value.anno.lipPeak != "无结果") {
      lipList.add([EXPLAN["lip_peak"], value.anno.lipPeak]);
    }
    if (value.anno.lipShape != null && value.anno.lipShape != "无结果") {
      lipList.add([EXPLAN["lip_shape"], value.anno.lipShape]);
    }

    if (value.anno.lipRadian != null && value.anno.lipRadian != "无结果") {
      lipList.add([EXPLAN["lip_radian"], value.anno.lipRadian]);
    }
    if (lipList.isNotEmpty) {
      selectMap.putIfAbsent("嘴唇部分", () => lipList);
    }

    List<List<String>> wrinkList = new List();
    if (value.anno.wrink != null && value.anno.wrink != "无结果") {
      wrinkList.add([EXPLAN["wrink"], value.anno.wrink]);
    }
    if (wrinkList.isNotEmpty) {
      selectMap.putIfAbsent("法令纹", () => wrinkList);
    }

    List<List<String>> cheekboneList = new List();
    if (value.anno.cheekbone != null && value.anno.cheekbone != "无结果") {
      cheekboneList.add([EXPLAN["cheekbone"], value.anno.cheekbone]);
    }
    if (cheekboneList.isNotEmpty) {
      selectMap.putIfAbsent("颧骨部分", () => cheekboneList);
    }

    List<List<String>> chinList = new List();
    if (value.anno.chinShape != null && value.anno.chinShape != "无结果") {
      chinList.add([EXPLAN["chin_shape"], value.anno.chinShape]);
    }
    if (chinList.isNotEmpty) {
      selectMap.putIfAbsent("下巴部分", () => chinList);
    }

    List<List<String>> faceList = new List();
    if (value.anno.face != null && value.anno.face != "无结果") {
      faceList.add([EXPLAN["face"], value.anno.face]);
    }
    if (faceList.isNotEmpty) {
      selectMap.putIfAbsent("脸型相关", () => faceList);
    }
    return selectMap;
  }
}
