/*
 * @author lsy
 * @date   2019-11-07
 **/

import 'dart:io';

import 'package:example_flutter/Annotations/RouterCenterRestore.mark.dart';
import 'package:example_flutter/HomeModel/page/picture/PicPage.dart';
import 'package:example_flutter/UserModel/service/Resp.dart';
import 'package:example_flutter/commonModel/GMBase.dart';
import 'package:example_flutter/commonModel/cache/CacheManager.dart';
import 'package:example_flutter/commonModel/toast/toast.dart';
import 'package:example_flutter/res/anim/Anim.dart';
import 'package:flutter/cupertino.dart';

import '../../../HomePage.dart';

class LoginModel extends BaseModel {
  resign(BuildContext context, String text, String text2) {
    Resp.getInstance().resign(text, text2).listen((value) {
      if (value != null && value.username != null) {
        login(context, text, text2);
      } else {
        Toast.show(context, "网络接口错误   ==> resign");
      }
    }).onError((error) {
      Navigator.pop(context);
      Toast.show(context, "该用户名已经被注册");
      print(error.toString());
    });
  }

  login(BuildContext context, String text, String text2) async {
//    CacheManager.getInstance().get(MEMORY_CACHE).save("userName", text);
//    Navigator.push(context, CustomRoute(HomePage()));
    Resp.getInstance().login(text, text2).listen((value) {
      CacheManager.getInstance()
          .get(MEMORY_CACHE)
          .save("token", value.token);
      CacheManager.getInstance().get(MEMORY_CACHE).save("userName", text);
      CacheManager.getInstance().get(MEMORY_CACHE).save("userWorld", text2);
      Resp.getInstance().getUserInfo().listen((info) {
        CacheManager.getInstance().get(MEMORY_CACHE).save("uid", info.uid);
        print("UID  ${info.uid}");
        Resp.getInstance().checkUser(info.uid).listen((check){
          CacheManager.getInstance().get(MEMORY_CACHE).save("checkId", check.power);
          Navigator.pop(context);
          if (value != null && value.token != null) {
            Toast.show(context, "登入成功");
            Navigator.push(context, CustomRoute(HomePage()));
          } else {
            Toast.show(context, "接口请求错误  ==> login");
          }
        }).onError((error){
          Toast.show(context, error.toString());
          print(error.toString());
          Navigator.pop(context);
        });

      }).onError((error) {
        Toast.show(context, error.toString());
        print(error.toString());
        Navigator.pop(context);
      });
    }).onError((error) {
      Navigator.pop(context);
      Toast.show(context, error.toString());
      print(error.toString());
    });
  }

  @override
  void dispose() {}
}
