/*
 * @author lsy
 * @date   2019-11-07
 **/
import 'dart:convert';
import 'dart:io';

import 'package:dio/dio.dart';
import 'package:example_flutter/UserModel/service/remote/api/UserApi.serv.dart';
import 'package:example_flutter/UserModel/service/remote/entity/UserBean.dart';
import 'package:example_flutter/UserModel/service/remote/entity/UserCheckBean.dart';
import 'package:example_flutter/UserModel/service/remote/entity/UserToken.dart';
import 'package:example_flutter/commonModel/GMBase.dart';
import 'package:flutter/foundation.dart';
import 'package:rxdart/rxdart.dart';

import 'remote/entity/UserInfoBean.dart';

class Resp {
  static Resp _resp;

  Resp._();

  static Resp getInstance() {
    if (_resp == null) {
      _resp = Resp._();
    }
    return _resp;
  }

  Observable<UserToken> login(String userName, String userWord) {
    return UserApiImpl().login(userName, userWord);
  }

  Observable<UserBean> resign(String userName, String userWord) {
    return UserApiImpl().resign(userName, userWord);
  }

  Observable<UserInfoBean> getUserInfo() {
    return UserApiImpl().getUserInfo();
  }

  Observable<UserCheckBean> checkUser(int id) {
    return Observable.fromFuture(DioUtil().getDio().get("check/${id}/"))
        .flatMap((value) {
      if (value != null &&
          (value.statusCode >= 200 && value.statusCode < 300)) {
        return Observable.fromFuture(compute(parseCheckBean, value.toString()));
      } else {
        return Observable.fromFuture(null);
      }
    });
  }
}

UserCheckBean parseCheckBean(String value) {
  return UserCheckBean.fromJson(json.decode(value));
}
