/*
 * @author lsy
 * @date   2019-10-13
 **/

import 'package:example_flutter/commonModel/toast/toast.dart';
import 'package:example_flutter/res/value/ALColors.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:flutter_svg/svg.dart';

MethodChannel channel = new MethodChannel("plugins.flutter.io/path_provider");
MethodChannel opencv = new MethodChannel("lsyyy");

Future getTempDir() {
  return channel.invokeMethod("getTemporaryDirectory");
}

Future<bool> saveString(String key, String value) {
  return channel.invokeMethod("setString", {"key": key, "value": value});
}

void getString(BuildContext context, String key, Function(String str) fun) {
  channel.invokeMethod("getString", {"key": key}).then((value) {
    fun(value);
  }).catchError((error) {
    Toast.show(context, error.toString());
    print(error.toString());
  });
}

Future<bool> clearSave() {
  return channel.invokeMethod("clear");
}

void getTempDirX(BuildContext context, Function(String dir) f) {
  getTempDir().then((value) {
    f(value);
  }).catchError((error) {
    Toast.show(context, error.toString());
    print(error.toString());
  });
}

Future<String> toImage(List<int> arr, String path, String needPath) {
  return channel.invokeMethod(
      "toImage", {"path": path, "list": arr, "needPath": needPath});
}

Future<String> opencvMethod(String readPath, String writePath) {
  return channel.invokeMethod("opencvImg", [readPath, writePath]);
}

Future<String> toImageTest(List<int> arr, String path, String needPath) {
  return channel.invokeMethod(
      "toImageTest", {"path": path, "list": arr, "needPath": needPath});
}

Future openCachce() {
  return channel.invokeMethod("openCache");
}

AppBar baseAppBar(
    {String title,
    List<Widget> action,
    bool centerTitle,
    VoidCallback backClick,
    Color backgroundColor}) {
  return baseAppBarChangeTitle(
      title: title == null
          ? Container()
          : baseText(title, 16, ALColors.Color323232),
      action: action,
      centerTitle: centerTitle,
      backClick: backClick,
      backgroundColor: backgroundColor);
}

AppBar baseAppBarChangeTitle(
    {Widget title,
    List<Widget> action,
    bool centerTitle,
    VoidCallback backClick,
    Color backgroundColor}) {
  return AppBar(
    backgroundColor:
        backgroundColor == null ? ALColors.ColorFFFFFF : backgroundColor,
    title: title,
    centerTitle: centerTitle,
    elevation: 0.0,
    leading: GestureDetector(
      onTap: backClick,
      child: Hero(
          tag: "left_arrow",
          child: Container(
              color: backgroundColor == null
                  ? ALColors.ColorFFFFFF
                  : backgroundColor,
              alignment: Alignment.centerLeft,
              padding: EdgeInsets.only(left: 22),
              width: 30,
              height: double.maxFinite,
              child: SvgPicture.asset(
                "image/left_arrow.svg",
                color: Color(0xff323232),
              ))),
    ),
    actions: action == null ? List<Widget>() : action,
  );
}

Text baseText(String text, double fontSize, Color color) {
  return Text(
    text,
    textScaleFactor: 1.0,
    softWrap: true,
    style: TextStyle(fontSize: fontSize, color: color),
  );
}

/**
 * 基础的liveView分割线
 */
Widget baseDivide(double height, double padding, Color color) {
  return Container(
      height: height,
      margin: EdgeInsets.only(
          right: ScreenUtil.instance.setWidth(padding),
          left: ScreenUtil.instance.setWidth(padding)),
      child: Container(
        color: color,
      ));
}

Widget loadingItem() {
  //TODO
  return Center(child: CircularProgressIndicator());
}

Widget netErrorItem() {}

//TODO

Widget baseFlatButtonItem(VoidCallback callback, String text) {
  return FlatButton(
    padding: EdgeInsets.only(top: 2, bottom: 2),
    color: Color.fromARGB(255, 236, 236, 236),
    onPressed: callback,
    child: baseText(text, 13, Colors.black),
  );
}

Widget baseButton(VoidCallback press, EdgeInsetsGeometry margin, String text) {
  return FlatButton(
    onPressed: press,
    child: Container(
      margin: margin,
      alignment: Alignment.center,
      width: 100,
      height: 39,
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(2),
        color: Colors.purple,
        gradient: LinearGradient(colors: [
          Color.fromARGB(255, 253, 113, 34),
          Color.fromARGB(255, 253, 166, 41)
        ], begin: Alignment.centerRight, end: Alignment.centerLeft),
      ),
      child: baseText(text, 15, Colors.white),
    ),
  );
}

Widget baseDivideRow() {
  return Container(
    width: 1,
    height: double.maxFinite,
    color: Colors.black38,
  );
}

Widget baseDivideColumn() {
  return Container(
    width: double.maxFinite,
    height: 1,
    color: Colors.black38,
  );
}
