/*
 * @author lsy
 * @date   2019-12-02
 **/

import 'package:example_flutter/commonModel/GMBase.dart';
import 'package:example_flutter/commonModel/picker/base/BaseCenterPicker.dart';
import 'package:example_flutter/commonModel/picker/base/DialogRouter.dart';
import 'package:flutter/material.dart';

class BaseDrawPicker extends StatefulWidget {
  BaseDrawPickerState centerState;
  IDrawPicker picker;
  bool cancelOutSide = true;

  setPicker(IDrawPicker picker) {
    this.picker = picker;
  }

  sync() {
    centerState?.setState(() {});
  }

  setCancelOutside(bool cancel) {
    this.cancelOutSide = cancel;
  }

  show(BuildContext context) {
    Navigator.push(context, DialogRouter(this));
  }

  dismiss(BuildContext context) {
    Navigator.pop(context);
  }

  @override
  State<StatefulWidget> createState() {
    centerState = BaseDrawPickerState();
    return centerState;
  }
}

class BaseDrawPickerState extends State<BaseDrawPicker>
    with SingleTickerProviderStateMixin {
  Animation<Offset> animation;
  LiveData<int> liveData = new LiveData();
  AnimationController controller;

  @override
  void initState() {
    super.initState();
    controller = new AnimationController(
        duration: const Duration(milliseconds: 300), vsync: this);
    animation =
        new Tween(begin: Offset(-1, 0), end: Offset(0, 0)).animate(controller)
          ..addListener(() {
            double dy = 1 - animation.value.dx.abs();
            if (dy < 0.2) {
              liveData.notifyView(null);
              return;
            }
            String alp = "${(dy.abs() * (99)).toInt()}";
            if (alp.length == 1) {
              alp = "0$alp";
            }
            String colorString = "0x${alp}000000";
            liveData.notifyView(int.parse(colorString));
          });
    controller.forward();
  }

  @override
  void dispose() {
    widget.picker.dispose();
    liveData.dispost();
    controller.dispose();
    super.dispose();
  }

  dis() {
    controller.reverse()
      ..whenComplete(() {
        Navigator.pop(context);
      });
  }

  @override
  Widget build(BuildContext context) {
//    ScreenUtil.instance = ScreenUtil(width: 375, height: 667)..init(context);
    return Container(
//      color: Colors.black54,
      width: double.maxFinite,
      height: double.maxFinite,
      child: Stack(
        alignment: Alignment.topLeft,
        children: <Widget>[
          GestureDetector(
              onTap: () {
                if (widget.cancelOutSide) {
                  dis();
//                widget.dismiss(context);
                }
              },
              child: StreamBuilder(
                stream: liveData.stream,
                builder: (con, data) {
                  if (data.data == null) {
                    return Container();
                  }
                  return Container(
                    width: double.maxFinite,
                    height: double.maxFinite,
                    color: Color(data.data),
                  );
                },
              )),
          SlideTransition(
              position: animation,
              child: Container(
                  child: Material(
                color: Colors.transparent,
                child: widget.picker.build(context, () {
                  dis();
                }),
              )))
        ],
      ),
    );
  }
}

abstract class IDrawPicker {
  Widget build(BuildContext context, VoidCallback dismiss);

  dispose();
}
