/*
 * @author lsy
 * @date   2019-11-22
 **/
import 'dart:async';
import 'dart:ui' as ui;

import 'package:flutter/material.dart';


Future<ui.Image> loadNetWorkImage(var path) async {
  ImageStream stream = NetworkImage(
    path,
  ).resolve(ImageConfiguration.empty);
  Completer<ui.Image> completer = Completer<ui.Image>();
  void listener(ImageInfo frame, bool synchronousCall) {
    final ui.Image image = frame.image as ui.Image;
    completer.complete(image);
    stream.removeListener(ImageStreamListener(listener));
  }
  stream.addListener(ImageStreamListener(listener));
  return completer.future;
}