/*
 * @author lsy
 * @date   2019-11-13
 **/

import 'package:event_bus/event_bus.dart';
import 'package:example_flutter/HomeModel/HomeRouterImpl.dart';
import 'package:example_flutter/HomeModel/page/data/DataCenter.dart';
import 'package:example_flutter/HomeModel/page/home/HomePage.dart';
import 'package:example_flutter/HomeModel/util/JumpUtil.dart';
import 'package:example_flutter/commonModel/GMBase.dart';
import 'package:example_flutter/commonModel/cache/CacheManager.dart';
import 'package:example_flutter/commonModel/eventbus/event/ChangeTabBean.dart';
import 'package:example_flutter/commonModel/eventbus/event/LogoutEvent.dart';
import 'package:example_flutter/commonModel/picker/base/BaseDrawPicker.dart';
import 'package:example_flutter/main.dart';
import 'package:example_flutter/res/anim/Anim.dart';
import 'package:example_flutter/res/value/ALColors.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/gestures.dart';
import 'package:flutter/material.dart';
import 'package:flutter_animation_set/widget/behavior_animations.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

getBaseTitle(BuildContext context) {
  String userName =
      CacheManager.getInstance().get(MEMORY_CACHE).get("userName");
  return baseAppBar(
      backgroundColor: ALColors.Color5276F4,
      backClick: () {
        Navigator.pop(context);
      },
      action: <Widget>[
        Expanded(
          child: Container(),
        ),
        Container(
          margin: EdgeInsets.only(right: ScreenUtil.instance.setWidth(10)),
          alignment: Alignment.center,
          child: baseText(userName, 30, ALColors.ColorF8F8F8),
        ),
        Container(
          width: kToolbarHeight,
          height: kToolbarHeight,
          margin: EdgeInsets.only(
              left: ScreenUtil.instance.setWidth(5),
              right: ScreenUtil.instance.setWidth(50),
              top: 5,
              bottom: 5),
          child: SvgPicture.asset("image/Face.svg"),
        ),
      ]);
}

baseShowPopMenu(BuildContext context, RelativeRect rect, List<String> contents,
    double itemWidght, Function(String vale) ok) async {
  List<PopupMenuItem<String>> list = new List();
  for (int i = 0; i < contents.length; i++) {
    list.add(PopupMenuItem(
        value: contents[i],
        child: Container(
          width: itemWidght,
          alignment: Alignment.center,
          child: baseText(contents[i], 12, ALColors.Color666666),
        )));
  }
  final result = await showMenu(context: context, position: rect, items: list);
  print(result);
  if (result != null) {
    ok(result);
  }
}

Widget basehead(BuildContext context) {
  String userName =
      CacheManager.getInstance().get(MEMORY_CACHE).get("userName");
  return Container(
    decoration:
        BoxDecoration(color: Color.fromARGB(255, 236, 236, 236), boxShadow: [
      BoxShadow(
        color: Colors.black38,
        blurRadius: 5.0,
      ),
    ]),
    height: kToolbarHeight,
    width: double.maxFinite,
    child: Row(
      crossAxisAlignment: CrossAxisAlignment.center,
      children: <Widget>[
        GestureDetector(
            onTap: () {
              BaseDrawPicker()
                ..setPicker(DrawPicker(["全部项目", "成员管理", "数据中心"]))
                ..show(context);
            },
            child: Container(
              margin: EdgeInsets.only(left: 22, right: 10),
              child: Icon(Icons.list),
            )),
        baseText("欢迎 ${userName} 使用更美AI标注平台", 15, Colors.black),
        Expanded(
          child: Container(),
        ),
        FlatButton(
          onPressed: () {
            baseShowPopMenu(
                context,
                RelativeRect.fromLTRB(MediaQuery.of(context).size.width - 150,
                    kToolbarHeight + 10, MediaQuery.of(context).size.width, 0),
                ["个人中心", "退出登入"],
                50, (value) {
              if (value == "个人中心") {
              } else if (value == "退出登入") {
                BaseCenterPicker()
                  ..setPicker(SurePicker("确定退出吗?", () {
                    Navigator.pop(context);
                  }, () {
                    Navigator.pop(context);
                    eventBus.fire(LogoutEvent());
                  }))
                  ..show(context);
              }
            });
          },
          child: Row(
            children: <Widget>[
              baseText(userName, 15, Colors.black),
              Icon(Icons.arrow_drop_down)
            ],
          ),
        ),
        Container(
          margin: EdgeInsets.only(right: 22),
          child: Icon(Icons.supervised_user_circle),
        )
      ],
    ),
  );
}

int drawSelectItem = 0;


class DrawPicker implements IDrawPicker {
  List<String> itemList;
  LiveData<int> liveData = new LiveData();
  static List<Widget> ownWidget=[HomePage(),DataCenter()];



  DrawPicker(this.itemList);

  Widget listItem(String wold) {
    return Container(
      alignment: Alignment.center,
      width: 260,
      height: 80,
      child: baseText(wold, 15, Colors.white),
    );
  }

  Widget selectItem(String word) {
    return Container(
        width: 260,
        height: 80,
        child: Row(
          children: <Widget>[
            Container(
              width: 5,
              height: 80,
              color: Colors.pink,
            ),
            Expanded(
              child: Container(
                alignment: Alignment.center,
                color: Color.fromARGB(255, 58, 72, 91),
                child: baseText(word, 15, Colors.white),
              ),
            )
          ],
        ));
  }

  @override
  Widget build(BuildContext context, VoidCallback dissmissCall) {
    return Container(
      width: 260,
      height: double.maxFinite,
      color: Color.fromARGB(255, 67, 81, 101),
      child: Column(
        children: <Widget>[
          Container(
            margin: EdgeInsets.only(bottom: 20),
            alignment: Alignment.center,
            width: 260,
            height: 80,
            color: Color.fromARGB(255, 58, 72, 91),
            child: baseText("AI标注平台", 23, Colors.white),
          ),
          Expanded(
            child: StreamBuilder<int>(
              stream: liveData.stream,
              builder: (con, data) {
                return ListView.builder(
                  itemBuilder: (con, index) {
                    if (drawSelectItem == index) {
                      return GestureDetector(
                        behavior: HitTestBehavior.opaque,
                        onTap: () {
                          dissmissCall();
                        },
                        child: selectItem(itemList[index]),
                      );
                    } else {
                      return GestureDetector(
                        behavior: HitTestBehavior.opaque,
                        onTap: () {
                          drawSelectItem = index;
                          liveData.notifyView(drawSelectItem);
                          dissmissCall();
                          eventBus.fire(ChangeTabBean(drawSelectItem));
//                          if (drawSelectItem == 0) {
//                            eventBus.fire(ChangeTabBean(0));
//                          } else if (drawSelectItem == 2) {
//                            eventBus.fire(ChangeTabBean(1));
//                          }
                        },
                        child: listItem(itemList[index]),
                      );
                    }
                  },
                  itemCount: itemList.length,
                );
              },
            ),
          )
        ],
      ),
    );
  }

  @override
  dispose() {
    liveData.dispost();
  }
}

Widget baseButton(VoidCallback press, EdgeInsetsGeometry margin, String text) {
  return FlatButton(
    onPressed: press,
    child: Container(
      margin: margin,
      alignment: Alignment.center,
      width: 100,
      height: 39,
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(2),
        color: Colors.purple,
        gradient: LinearGradient(colors: [
          Color.fromARGB(255, 253, 113, 34),
          Color.fromARGB(255, 253, 166, 41)
        ], begin: Alignment.centerRight, end: Alignment.centerLeft),
      ),
      child: baseText(text, 15, Colors.white),
    ),
  );
}

class SurePicker implements ICenterPicker {
  VoidCallback cancel;
  VoidCallback sure;
  final String showText;

  SurePicker(this.showText, this.cancel, this.sure);

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.all(Radius.circular(20))),
      width: 350,
      height: 260,
      child: Column(
        children: <Widget>[
          Expanded(
            child: Container(
              alignment: Alignment.center,
              child: baseText(showText, 15, Colors.black),
            ),
          ),
          Container(
            height: 1,
            width: double.maxFinite,
            color: Colors.black54,
          ),
          Container(
            width: double.maxFinite,
            height: 50,
            child: Row(
              children: <Widget>[
                Expanded(
                  child: GestureDetector(
                      onTap: cancel,
                      child: Container(
                        color: Colors.transparent,
                        alignment: Alignment.center,
                        child: baseText("取消", 12, Colors.black38),
                      )),
                ),
                Container(
                  width: 1,
                  height: double.maxFinite,
                  color: Colors.black54,
                ),
                Expanded(
                  child: GestureDetector(
                    onTap: sure,
                    child: Container(
                      color: Colors.transparent,
                      alignment: Alignment.center,
                      child: baseText("确定", 12, Colors.red),
                    ),
                  ),
                )
              ],
            ),
          )
        ],
      ),
    );
  }
}

class MyAppBar extends StatelessWidget implements PreferredSizeWidget {
  @override
  Widget build(BuildContext context) {
    return basehead(context);
  }

  @override
  Size get preferredSize => Size.fromHeight(kToolbarHeight);
}

class StickyTabBarDelegate extends SliverPersistentHeaderDelegate {
  final TabBar child;

  StickyTabBarDelegate({@required this.child});

  @override
  Widget build(
      BuildContext context, double shrinkOffset, bool overlapsContent) {
    return this.child;
  }

  @override
  double get maxExtent => this.child.preferredSize.height;

  @override
  double get minExtent => this.child.preferredSize.height;

  @override
  bool shouldRebuild(SliverPersistentHeaderDelegate oldDelegate) {
    return true;
  }
}

Widget refreshView(RefreshController refreshController, VoidCallback refresh,
    Widget topFix, Widget List) {
  return SmartRefresher(
      enablePullDown: true,
      enablePullUp: false,
      header: WaterDropMaterialHeader(
        backgroundColor: Color.fromARGB(255, 236, 236, 236),
      ),
      controller: refreshController,
      onRefresh: refresh,
      child: CustomScrollView(
        slivers: <Widget>[
          SliverToBoxAdapter(
            child: topFix,
          ),
          List
        ],
      ));
}

Widget refreshloadingItem(VoidCallback callback) {
  Widget loadCircle = Column(
    mainAxisAlignment: MainAxisAlignment.start,
    children: <Widget>[
      Expanded(
        child: Container(),
      ),
      Container(
        decoration: BoxDecoration(
          shape: BoxShape.circle,
          color: Colors.orange,
        ),
        alignment: Alignment.center,
        width: 100,
        height: 100,
        child: YYSingleLike(),
      ),
      Padding(
        padding: EdgeInsets.only(left: 10, right: 10, top: 10, bottom: 10),
        child: RichText(
          text: TextSpan(
            text: '等待选取图片,点击上方按钮和',
            style: TextStyle(fontSize: 14, color: Colors.black),
            children: [
              TextSpan(
                text: ' 这里 ',
                style: TextStyle(fontSize: 14, color: Colors.blue),
                recognizer: TapGestureRecognizer()..onTap = callback,
              ),
              TextSpan(
                text: '都可以打开上传框哦',
                style: TextStyle(fontSize: 14, color: Colors.black),
              ),
              WidgetSpan(
                alignment: PlaceholderAlignment.middle,
                child: Image.asset(
                  'assets/noavatar.png',
                  width: 20,
                  height: 20,
                ),
              ),
            ],
          ),
        ),
      ),
      Expanded(
        child: Container(),
      ),
    ],
  );
  return SliverFillViewport(delegate: SliverChildListDelegate([loadCircle]));
}
