/*
 * @author lsy
 * @date   2019-12-03
 **/
import 'dart:async';

import 'package:example_flutter/HomeModel/base/BaseTitle.dart';
import 'package:example_flutter/HomeModel/page/createProject/CreateProjectModel.dart';
import 'package:example_flutter/commonModel/base/BaseComponent.dart';
import 'package:example_flutter/commonModel/base/BaseState.dart';
import 'package:example_flutter/main.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class CreateProject extends StatefulWidget {
  @override
  State<StatefulWidget> createState() => CreateProjectState();
}

class CreateProjectState extends BaseState<CreateProject> {
  CreateProjectModel _model;
  TextEditingController nameController;
  TextEditingController contentController;

  @override
  void initState() {
    nameController = TextEditingController();
    contentController = TextEditingController();
    _model = new CreateProjectModel();
    super.initState();
  }

  @override
  void dispose() {
    nameController.dispose();
    contentController.dispose();
    _model.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: MyAppBar(),
      body: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: <Widget>[
          Container(
            margin: EdgeInsets.only(left: 22, top: 22),
            child: baseText("新建项目", 15, Colors.black),
          ),
          Container(
            margin: EdgeInsets.only(left: 22, top: 5, bottom: 20),
            child: baseText("请耐心按顺序认真的填写项目内容", 15, Colors.black),
          ),
          StreamBuilder(
            stream: _model.currentIndexLive.stream,
            initialData: _model.currentIndexLive.data,
            builder: (con, data) {
              if (data.data == null) {
                return Container();
              }
              return Row(
                children: <Widget>[
                  Container(
                    width: 22,
                  ),
                  GestureDetector(
                      onTap: () {
                        _model.tabChange(1);
                      },
                      child: Column(
                        children: <Widget>[
                          Icon(
                            Icons.looks_one,
                            size: 50,
                            color: Colors.yellow,
                          ),
                          Container(
                            height: 5,
                          ),
                          baseText("填写项目名称", 15, Colors.black)
                        ],
                      )),
                  Container(
                    margin: EdgeInsets.only(left: 20, right: 20, bottom: 20),
                    width: 230,
                    height: 1,
                    color: data.data == 2 ? Colors.black : Colors.grey,
                  ),
                  GestureDetector(
                      onTap: () {
                        _model.tabChange(2);
                      },
                      child: Column(
                        children: <Widget>[
                          Icon(
                            Icons.looks_two,
                            size: 50,
                            color:
                                data.data == 2 ? Colors.yellow : Colors.black,
                          ),
                          Container(
                            height: 5,
                          ),
                          baseText("上传或选择已有的数据集", 15,
                              data.data == 2 ? Colors.black : Colors.grey)
                        ],
                      ))
                ],
              );
            },
          ),
          StreamBuilder<ProjectUI>(
            stream: _model.projectLive.stream,
            initialData: _model.projectLive.data,
            builder: (con, data) {
              if (data.data == null) {
                return Container();
              }
              if (data.data.index == 1) {
                return page1();
              } else if (data.data.index == 2) {
                return page2();
              }
            },
          )
        ],
      ),
    );
  }

  Widget page2() {
    return Expanded(
      child: Column(
        children: <Widget>[
          Expanded(
            child: Row(
              children: <Widget>[
                Expanded(
                  flex: 1,
                  child: Container(
                    height: double.maxFinite,
                    margin: EdgeInsets.all(20),
                    child: Card(
                      elevation: 10,
                      child: Column(
                        children: <Widget>[

                        ],
                      ),
                    ),
                  ),
                ),
                Expanded(
                  flex: 3,
                  child: Container(
                    height: double.maxFinite,
                    margin: EdgeInsets.fromLTRB(20, 20, 300, 20),
                    child: Card(
                      elevation: 10,
                      child: ListView(
                        children: <Widget>[
                          baseText("wdwad", 16, Colors.black),
                          baseText("wdwad", 16, Colors.black),
                        ],
                      ),
                    ),
                  ),
                ),
              ],
            ),
          ),
          Container(
            height: 20,
          ),
          Row(
            children: <Widget>[
              baseButton(() {
                //TODO
              }, EdgeInsets.only(), "完成"),
              Container(
                width: 10,
              ),
              baseButton(() {
                Navigator.pop(context);
              }, EdgeInsets.only(), "返回"),
            ],
          ),
          Container(
            height: 20,
          ),
        ],
      ),
    );
  }

  Widget page1() {
    return Expanded(
      child: Column(
        children: <Widget>[
          Container(
            margin: EdgeInsets.only(left: 22, top: 50, right: 500),
            child: TextFormField(
              decoration: InputDecoration(
                labelText: '请输入项目名称',
                hintText: "项目名称",
                hintStyle: TextStyle(
                  color: Colors.grey,
                  fontSize: 13,
                ),
                prefixIcon: Icon(Icons.nature),
              ),
              //校验用户
              validator: (value) {
                return value.trim().length > 0 ? null : "项目名称不能为空";
              },
              controller: nameController,
            ),
          ),
          Container(
            margin: EdgeInsets.only(left: 22, top: 30, right: 500),
            child: TextFormField(
              decoration: InputDecoration(
                labelText: '请输入项目描述',
                hintText: "项目描述",
                hintStyle: TextStyle(
                  color: Colors.grey,
                  fontSize: 13,
                ),
                prefixIcon: Icon(Icons.content_copy),
              ),
              //校验用户
              validator: (value) {
                return value.trim().length > 0 ? null : "项目描述不能为空";
              },
              controller: contentController,
            ),
          ),
          Container(
            height: 80,
          ),
          Row(
            children: <Widget>[
              baseButton(() {
                _model.next(
                    context, nameController.text, contentController.text);
              }, EdgeInsets.only(), "下一步"),
              Container(
                width: 10,
              ),
              baseButton(() {
                Navigator.pop(context);
              }, EdgeInsets.only(), "返回"),
            ],
          )
        ],
      ),
    );
  }
}
