/*
 * @author lsy
 * @date   2019-12-02
 **/
import 'dart:async';

import 'package:example_flutter/HomeModel/base/BaseTitle.dart';
import 'package:example_flutter/HomeModel/page/data/DataCenterModel.dart';
import 'package:example_flutter/commonModel/GMBase.dart';
import 'package:example_flutter/commonModel/base/BaseState.dart';
import 'package:example_flutter/commonModel/eventbus/event/LogoutEvent.dart';
import 'package:example_flutter/main.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class DataCenter extends StatefulWidget {
  @override
  State<StatefulWidget> createState() => DataCenterState();
}

class DataCenterState extends BaseState<DataCenter> {
  DataCenterModel _model;
  RefreshController _refreshController =
      RefreshController(initialRefresh: false);

  DataCenterState() {
    _model = DataCenterModel();
  }

  @override
  void initState() {
    super.initState();
    _model.init(context);
  }

  @override
  void dispose() {
    _model.dispose();
    _refreshController.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: MyAppBar(),
      body:
          refreshView(_refreshController, _onLoading, topTitle(), renderList()),
    );
  }

  void _onLoading() {
    //TODO
    Timer(Duration(seconds: 1), () {
      _refreshController.refreshCompleted();
    });
  }

  Widget renderList() {
    return StreamBuilder(
      stream: _model.liveData.stream,
      initialData: _model.liveData.data,
      builder: (context, data) {
        if (data.data == null) {
          return refreshloadingItem((){

          });
        }
        return SliverPadding(
            padding: EdgeInsets.only(right: 300, left: 20),
            sliver: SliverGrid(
                gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
                    crossAxisCount: 5, childAspectRatio: 0.9),
                delegate: SliverChildBuilderDelegate(
                    (BuildContext context, int index) {
                  return GestureDetector(
                      behavior: HitTestBehavior.opaque,
                      onTap: () {
                        print("clickk ");
                      },
                      child: Card(
                        shape: const RoundedRectangleBorder(
                            borderRadius:
                                BorderRadius.all(Radius.circular(15.0))), //设置圆角
                        elevation: 5,
                        margin: EdgeInsets.all(10),
                        child: Column(
                          children: <Widget>[
                            Container(
                              width: double.maxFinite,
                              height: 160,
                              child: ClipRRect(
                                  borderRadius: BorderRadius.vertical(
                                      top: Radius.circular(15)),
                                  child: Image.network(
                                    "http://b-ssl.duitang.com/uploads/item/201208/30/20120830173930_PBfJE.jpeg",
                                    fit: BoxFit.cover,
                                  )),
                            ),
                            Container(
                              width: double.maxFinite,
                              height: 1,
                              color: Colors.black12,
                            ),
                            Container(
                              alignment: Alignment.topLeft,
                              margin: EdgeInsets.only(
                                left: 16,
                                top: 5,
                              ),
                              child: baseText("www", 15, Colors.black),
                            ),
                            Container(
                              alignment: Alignment.topLeft,
                              margin:
                                  EdgeInsets.only(left: 16, top: 5, right: 16),
                              child: Row(
                                children: <Widget>[
                                  baseText("www", 12, Colors.black),
                                  Expanded(
                                    child: Container(),
                                  ),
                                  baseText("0/8", 12, Colors.black)
                                ],
                              ),
                            ),
                          ],
                        ),
                      ));
                })));
      },
    );
  }

  Widget topTitle() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: <Widget>[
        baseButton(() {
          //TODO
        }, EdgeInsets.fromLTRB(10, 20, 10, 20), "新建数据集"),
        Container(
          margin: EdgeInsets.only(left: 30, bottom: 5),
          child: baseText("数据集", 12, Colors.black),
        ),
        StreamBuilder(
          stream: _model.countLive.stream,
          initialData: _model.countLive.data,
          builder: (con, data) {
            int all = 0;
            if (data.data != null) {
              all = data.data;
            }
            return Container(
              margin: EdgeInsets.only(left: 30, bottom: 10),
              child: baseText("总共 ${all}", 12, Colors.black),
            );
          },
        )
      ],
    );
  }
}
