/*
 * @author lsy
 * @date   2019-11-07
 **/
import 'dart:async';
import 'dart:convert';
import 'dart:io';

import 'package:dio/dio.dart';
import 'package:example_flutter/HomeModel/page/picture/PicPage.dart';
import 'package:example_flutter/HomeModel/page/work/WorkPage.dart';
import 'package:example_flutter/HomeModel/service/HomeRepo.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/AllProjectBean.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/UploadResultBean.dart';
import 'package:example_flutter/commonModel/GMBase.dart';
import 'package:example_flutter/commonModel/picker/base/BasePickerComponent.dart';
import 'package:example_flutter/commonModel/toast/toast.dart';
import 'package:example_flutter/res/anim/Anim.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter/src/widgets/framework.dart';
import 'package:file_chooser/file_chooser.dart';

import 'UploadBean.dart';

class HomeModel extends BaseModel {
  HomeRepo repo = HomeRepo.getInstance();
  List<UploadResultBean> scanList = new List();
  int allSize;
  int nowSize;
  List<String> uploadFile = new List();
  LiveData<List<UploadItem>> uploadLive = new LiveData();

  @override
  void dispose() {
    uploadLive.dispost();
  }

  init() {
//    allprojectLive.notifyView(AllProjectBean("w"));
  }

  void scanImages(BuildContext context) async {
    await showOpenPanel((result, files) {
      if (result != FileChooserResult.ok || files.isEmpty) {
        Toast.show(context, "没有选择文件 批量上传 可以按住shift 或者拖拽鼠标！");
        return;
      }
      List<UploadItem> items = new List();
      files.forEach((value) {
        items.add(new UploadItem()
          ..path = value);
      });
      uploadLive.notifyView(items);
      allSize = files.length;
      nowSize = 0;
      scanList.clear();
      uploadFile.clear();
      uploadFile.addAll(files);
      uploadImage(context, uploadFile[nowSize]);
    }, allowsMultipleSelection: true);
  }

  void uploadImage(BuildContext context,
      String path,) {
    netUpload(path).then((value) {
      if (value != null &&
          (value.statusCode >= 200 && value.statusCode < 300)) {
        uploadLive.data[nowSize].state=1;
        uploadLive.notifyView(uploadLive.data);
        nowSize++;
        if (allSize == nowSize) {
          Toast.show(context, "上传成功");
//          repo.updateScanList(scanList);
          success(context);
        } else {
          uploadImage(context, uploadFile[nowSize]);
        }
      } else {
        Toast.show(context, "上传图片返回接口有空值 暂停上传");
        print("上传图片返回接口有空值 暂停上传");
      }
    }).catchError((erro) {
      Toast.show(context, erro.toString());
      print(erro.toString());
      uploadLive.data[nowSize].state=2;
      uploadLive.notifyView(uploadLive.data);
      nowSize++;
      if(nowSize<allSize) {
        uploadImage(context, uploadFile[nowSize]);
      }
    });
  }

  void success(BuildContext buildContext) {
    Navigator.push(buildContext, CustomRoute(PicPage()));
  }
}

Future<Response> netUpload(String path) async {
  return DioUtil.getInstance().uploadFile("image-upload/", path);
}

UploadResultBean uploadImg(String value) {
  return UploadResultBean.fromJson(json.decode(value));
}
