/*
 * @author lsy
 * @date   2019-11-07
 **/
import 'dart:async';
import 'dart:io';

import 'package:event_bus/event_bus.dart';
import 'package:example_flutter/HomeModel/base/BaseTitle.dart';
import 'package:example_flutter/HomeModel/page/createProject/CreateProject.dart';
import 'package:example_flutter/HomeModel/page/home/HomeModel.dart';
import 'package:example_flutter/HomeModel/page/home/UploadHideView.dart';
import 'package:example_flutter/HomeModel/page/picture/PicPage.dart';
import 'package:example_flutter/HomeModel/page/work/WorkPage.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/AllProjectBean.dart';
import 'package:example_flutter/HomeModel/util/JumpUtil.dart';
import 'package:example_flutter/commonModel/base/BaseComponent.dart';
import 'package:example_flutter/commonModel/base/BaseState.dart';
import 'package:example_flutter/commonModel/cache/CacheManager.dart';
import 'package:example_flutter/commonModel/eventbus/event/LogoutEvent.dart';
import 'package:example_flutter/main.dart';
import 'package:example_flutter/res/GMRes.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_animation_set/widget/transition_animations.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

import 'UploadBean.dart';

class HomePage extends StatefulWidget {
  @override
  State<StatefulWidget> createState() => HomeState();
}

class HomeState extends BaseState<HomePage>
    with SingleTickerProviderStateMixin {
  HomeModel _model;
  Size screenSize;
  String userName;
  RefreshController _refreshController =
      RefreshController(initialRefresh: false);
  Animation<double> animation;
  AnimationController controller;
  double animValue = 0.0;

  HomeState() {
    _model = new HomeModel();
  }

  @override
  void initState() {
    super.initState();
    _model.init();
//    controller = new AnimationController(
//        duration: const Duration(milliseconds: 3000), vsync: this);
//    animation = new Tween(begin: 0.0, end: 1.0).animate(controller)
//      ..addListener(() {
//          animValue = controller.value;
//      });
//    controller.repeat();
  }

  @override
  void dispose() {
//    controller.dispose();
    _refreshController.dispose();
    _model.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    screenSize = MediaQuery.of(context).size;
    userName = CacheManager.getInstance().get(MEMORY_CACHE).get("userName");
    return Scaffold(
      appBar: MyAppBar(),
      body:
          refreshView(_refreshController, _onLoading, topTitle(), renderList()),
    );
  }

  void _onLoading() {
    //TODO
    Timer(Duration(seconds: 1), () {
      _refreshController.refreshCompleted();
    });
  }

  Widget renderList() {
    return StreamBuilder<List<UploadItem>>(
      stream: _model.uploadLive.stream,
      initialData: _model.uploadLive.data,
      builder: (context, data) {
        if (data.data == null) {
          return refreshloadingItem(() {
            _model.scanImages(context);
          });
        }
        return SliverPadding(
            padding: EdgeInsets.only(right: 300, left: 20),
            sliver: SliverGrid(
                gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
                    crossAxisCount: 5, childAspectRatio: 0.9),
                delegate: SliverChildBuilderDelegate(
                    (BuildContext context, int index) {
                  return GestureDetector(
                      behavior: HitTestBehavior.opaque,
                      onTap: () {
                        print("clickk ");
                      },
                      child: Stack(
                        children: <Widget>[
                          PicItem(data.data[index].path),
                          _model.nowSize == index && data.data[index].state == 0
                              ? Container(
                                  margin: EdgeInsets.all(25),
                                  alignment: Alignment.center,
                                  width: double.maxFinite,
                                  height: double.maxFinite,
                                  child: Container(
                                    width: 40,
                                    height: 40,
                                    child: MyYYRotatingCircle(Colors.orange),
                                  ))
                              : Container(
                                  margin: EdgeInsets.all(10),
                                  width: double.maxFinite,
                                  height: double.maxFinite,
                                  child: CustomPaint(
                                      painter: UploadHideView(
                                          data.data[index].state,
                                          animValue,
                                          data.data[index].progress)),
                                ),
                        ],
                      ));
                }, childCount: data.data.length)));
      },
    );
  }

  Widget PicItem(String path) {
    return Card(
      shape: const RoundedRectangleBorder(
          borderRadius: BorderRadius.all(Radius.circular(15.0))), //设置圆角
      elevation: 5,
      margin: EdgeInsets.all(10),
      child: Column(
        children: <Widget>[
          Container(
            width: double.maxFinite,
            height: 160,
            child: ClipRRect(
                borderRadius: BorderRadius.vertical(top: Radius.circular(15)),
                child: Image.file(
                  File(path),
                  fit: BoxFit.cover,
                )),
          ),
          Container(
            width: double.maxFinite,
            height: 1,
            color: Colors.black12,
          ),
          Container(
            alignment: Alignment.topLeft,
            margin: EdgeInsets.only(
              left: 16,
              top: 15,
            ),
            child: baseText(
                path.substring(path.lastIndexOf("/") + 1, path.length),
                15,
                Colors.black),
          ),
//          Container(
//            alignment: Alignment.topLeft,
//            margin:
//            EdgeInsets.only(left: 16, top: 5, right: 16),
//            child: Row(
//              children: <Widget>[
//                baseText("www", 12, Colors.black),
//                Expanded(
//                  child: Container(),
//                ),
//                baseText("0/8", 12, Colors.black)
//              ],
//            ),
//          ),
        ],
      ),
    );
  }

  Widget topTitle() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: <Widget>[
        Row(
          children: <Widget>[
            baseButton(() {
              _model.scanImages(context);
            }, EdgeInsets.fromLTRB(10, 20, 10, 20), "上传图片"),
            baseButton(() {
              JumpUtil.jumpToPage(context, WorkPage(
                "http://i1.sinaimg.cn/ent/d/2008-06-04/U105P28T3D2048907F326DT20080604225106.jpg"
                    ,1,0
              ));
            }, EdgeInsets.fromLTRB(10, 20, 10, 20), "下一步"),
          ],
        ),
        Container(
          margin: EdgeInsets.only(left: 30, bottom: 10),
          child: baseText("全部图片", 12, Colors.black),
        ),
      ],
    );
  }

  uploadItem() {
    return Container(
        decoration: BoxDecoration(
            image: DecorationImage(
                fit: BoxFit.cover,
                image: NetworkImage(
                    'https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1573655792197&di=f9469fa087a082aedfd22514c1549e1f&imgtype=0&src=http%3A%2F%2Fimg8.zol.com.cn%2Fbbs%2Fupload%2F19571%2F19570481.jpg'))),
        padding: EdgeInsets.only(
            top: ScreenUtil.instance.setWidth(50),
            bottom: ScreenUtil.instance.setWidth(80),
            left: ScreenUtil.instance.setWidth(80),
            right: ScreenUtil.instance.setWidth(80)),
        alignment: Alignment.center,
        width: screenSize.width,
        height: double.maxFinite,
        child: InkWell(
            onTap: () {
              _model.scanImages(context);
            },
            child: Container(
              decoration: BoxDecoration(
                borderRadius: BorderRadius.all(
                  //圆角
                  Radius.circular(20.0),
                ),
                border: Border.all(width: 1.0),
              ),
              alignment: Alignment.center,
              width: double.maxFinite,
              height: double.maxFinite,
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.center,
                children: <Widget>[
                  Container(
                      height: 25,
                      width: 100,
                      color: Colors.blueAccent,
                      child: FlatButton(
                        onPressed: () {
                          Navigator.push(context, CustomRoute(PicPage()));
                        },
                        child: baseText("跳过", 15, Colors.white),
                      )),
                  Expanded(
                    child: Container(),
                  ),
                  SvgPicture.asset("image/add.svg"),
                  Container(
                    margin: EdgeInsets.only(top: 30),
                    child: baseText("点击上传照片", 20, ALColors.ColorE4E4E4),
                  ),
                  Expanded(
                    child: Container(),
                  ),
                ],
              ),
            )));
  }
}
