/*
 * @author lsy
 * @date   2019-12-05
 **/
import 'dart:async';

import 'package:example_flutter/commonModel/eventbus/event/LogoutEvent.dart';
import 'package:flutter/material.dart';

import '../../main.dart';

abstract class BaseState<T extends StatefulWidget> extends State<T>{

  StreamSubscription<LogoutEvent> busEvent;

  @override
  void initState() {
    busEvent = eventBus.on<LogoutEvent>().listen((event) {
      Navigator.pop(context);
    });
    super.initState();
  }

  @override
  void dispose() {
    busEvent.cancel();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    // TODO: implement build
    throw UnimplementedError();
  }

}