/*
 * @author lsy
 * @date   2019-11-13
 **/

import 'package:example_flutter/commonModel/GMBase.dart';
import 'package:example_flutter/commonModel/cache/CacheManager.dart';
import 'package:example_flutter/res/value/ALColors.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:flutter_svg/flutter_svg.dart';

getBaseTitle(BuildContext context) {
  String userName =
      CacheManager.getInstance().get(MEMORY_CACHE).get("userName");
  return baseAppBar(
      backgroundColor: ALColors.Color5276F4,
      backClick: () {
        Navigator.pop(context);
      },
      action: <Widget>[
        Expanded(
          child: Container(),
        ),
        Container(
          margin: EdgeInsets.only(right: ScreenUtil.instance.setWidth(10)),
          alignment: Alignment.center,
          child: baseText(userName, 30, ALColors.ColorF8F8F8),
        ),
        Container(
          width: kToolbarHeight,
          height: kToolbarHeight,
          margin: EdgeInsets.only(
              left: ScreenUtil.instance.setWidth(5),
              right: ScreenUtil.instance.setWidth(50),
              top: 5,
              bottom: 5),
          child: SvgPicture.asset("image/Face.svg"),
        ),
      ]);
}
