/*
 * @author lsy
 * @date   2019-11-13
 **/
import 'dart:io';

import 'package:example_flutter/HomeModel/page/work/WorkModel.dart';
import 'package:example_flutter/HomeModel/page/work/WorkPage.dart';
import 'package:example_flutter/HomeModel/service/HomeRepo.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/ImageResultBean.dart';
import 'package:example_flutter/HomeModel/service/remote/entity/TotalImageBean.dart';
import 'package:example_flutter/commonModel/GMBase.dart';
import 'package:example_flutter/commonModel/picker/base/BasePickerComponent.dart';
import 'package:example_flutter/commonModel/toast/toast.dart';
import 'package:example_flutter/res/anim/Anim.dart';
import 'package:flutter/cupertino.dart';

class PicModel extends BaseModel {
  HomeRepo _repo;
  LiveData<List<PicList>> imageLive = new LiveData();
  LiveData<int> countLive = new LiveData();

  LiveData<TotalImageBean> totalLive = new LiveData();

  PicModel() {
    _repo = HomeRepo.getInstance();
    countLive.notifyView(_repo.currentPage);
  }

  void getImages(BuildContext context, bool showPop) {
    if (showPop) {
      BaseCenterPicker()
        ..setPicker(BaseLoadingItem("加载中。。。"))
        ..show(context);
    }
    _repo.getImageResult(_repo.currentPage, 9).listen((data) {
      _repo.updateCurrentPageList(data.picList);
      imageLive.notifyView(data.picList);
      if (showPop) {
        Navigator.pop(context);
      }
    }).onError((error) {
      Toast.show(context, error.toString());
      print(error.toString());
      if (showPop) {
        Navigator.pop(context);
      }
    });
  }

  void getTotalImages(BuildContext context) {
    _repo.getTotalImage().listen((value) {
      totalLive.notifyView(value);
    }).onError((error) {
      Toast.show(context, error.toString());
      print(error.toString());
    });
  }

  @override
  void dispose() {
    imageLive.dispost();
    countLive.dispost();
    totalLive.dispost();
  }

  void onItemClick(BuildContext context, int index) {
    Navigator.push(
            context,
            new CustomRoute(WorkPage(_repo.getCurrentPageList()[index].picurl,
                _repo.getCurrentPageList()[index].id, index)))
        .then((value) {
      if (value == -1) {
        getImages(context, false);
      } else {
        imageLive.notifyView(_repo.getCurrentPageList());
      }
      countLive.notifyView(_repo.currentPage);
    });
  }

  void after(BuildContext context) {
    BaseCenterPicker()
      ..setPicker(BaseLoadingItem("加载中。。。"))
      ..show(context);
    _repo.getImageResult(_repo.currentPage + 1, 9).listen((data) {
      if (data == null || data.picList == null || data.picList.isEmpty) {
        Toast.show(context, "已经是最后一页了哦～");
      } else {
        _repo.currentPage = _repo.currentPage + 1;
        _repo.updateCurrentPageList(data.picList);
        imageLive.notifyView(data.picList);
      }
      countLive.notifyView(_repo.currentPage);
      Navigator.pop(context);
    }).onError((error) {
      Toast.show(context, error.toString());
      print(error.toString());
      Navigator.pop(context);
    });
  }

  void before(BuildContext context) {
    if (_repo.currentPage == 1) {
      Toast.show(context, "已经是第一页了哦");
      return;
    }
    _repo.currentPage = _repo.currentPage - 1;
    getImages(context, true);
    countLive.notifyView(_repo.currentPage);
  }

  void onDeleteItem(BuildContext context, int index) {
    //TODO
    BaseCenterPicker()
      ..setPicker(SurePicker("确定删除这张照片吗？", () {
        Navigator.pop(context);
      }, () {
        Navigator.pop(context);
        //DELETE
        _repo.deleteItem(_repo.getCurrentPageList()[index].id).listen((value) {
          if (value != null && value.result == "DeleteSucceed") {
            //OK
            _repo.getImageResult(_repo.currentPage, 9).listen((data) {
              if (data != null &&
                  data.picList != null &&
                  data.picList.isNotEmpty) {
                _repo.updateCurrentPageList(data.picList);
                imageLive.notifyView(data.picList);
              } else {
                if (_repo.currentPage == 1) {
                  Toast.show(context, "没有数据了");
                } else {
                  _repo
                      .getImageResult(_repo.currentPage - 1, 9)
                      .listen((value) {
                    _repo.currentPage = _repo.currentPage - 1;
                    _repo.updateCurrentPageList(data.picList);
                    imageLive.notifyView(data.picList);
                  }).onError((error) {
                    Toast.show(context, error.toString());
                    print(error.toString());
                  });
                }
              }
            }).onError((error) {
              Toast.show(context, error.toString());
              print(error.toString());
            });
          }
        }).onError((error) {
          Toast.show(context, error.toString());
          print(error.toString());
        });
      }))
      ..show(context);
  }
}
