/*
 * @author lsy
 * @date   2019-11-14
 **/

import 'package:flutter/cupertino.dart';

const String TEST_IMAGES = """
{
    "pic_list": [
        {
            "picurl": "https://anno-1258538551.cos.ap-chengdu.myqcloud.com/f540275d1e6d2fbad9273a8f17924e94.png",
            "id": 11,
            "status": "2"
        },
        {
            "picurl": "https://anno-1258538551.cos.ap-chengdu.myqcloud.com/f540275d1e6d2fbad9273a8f17924e94",
            "id": 12,
            "status": "2"
        }
    ]
}
""";

const String CACHE_JSON = """
{
	"left_eye": {
		"name": "左眼",
		"leftEyeData": {
			"seye": "单眼皮",
			"eyes": "双眼皮",
			"doubleIn": "内双"
		}

	},

	"rigth_eye": {
		"name": "右眼",
		"rigthEyeData": {
			"seye": "单眼皮",
			"eyes": "双眼皮",
			"doubleIn": "内双"
		}

	},

	"eyebag": {
		"name": "眼袋",
		"eyebagData": {
			"yes": "有",
			"no": "无"
		}

	},

	"eyestyle_left": {
		"name": "左眼风格",
		"eyestyleLeftData": {
			"Almon_eyes": "杏眼",
			"Peach": "桃花眼",
			"Fine_cheng": "细凤眼",
			"deer_eye": "小鹿眼",
			"dog_eye": "小狗眼"

		}

	},

	"eyestyle_right": {
		"name": "右眼眼风格",
		"eyestyleRightData": {
			"Almon_eyes": "杏眼",
			"Peach": "桃花眼",
			"Fine_cheng": "细凤眼",
			"deer_eye": "小鹿眼",
			"dog_eye": "小狗眼"

		}
	},

	"nose": {
		"name": "鼻翼",
		"noseData": {
			"Narrow_nose": "窄鼻翼",
			"Standard_nose": "标准鼻翼",
			"widep_nose": "偏宽鼻翼",
			"wide_nose": "宽鼻翼"
		}

	},

	"mouth": {
		"name": "嘴唇厚度",
		"mouthData": {
			"Standard": "标准唇",
			"Thick": "厚唇",
			"thin": "薄唇"

		}
	},

	"lip": {
		"name": "唇峰",
		"lipData": {
			"yes": "有",
			"no": "无",
			"not_obvious": "有唇峰，但不明显"
		}

	},

	"wrink": {
		"name": "法令纹",
		"wrinkData": {
			"yes": "有",
			"no": "无"

		}
	},

	"checkbone": {
		"name": "颧骨",
		"checkboneData": {
			"high": "高颧骨",
			"flat": "平颧骨"
		}

	},

	"eyebow": {
		"name": "眉毛挑度",
		"eyebowData": {
			"On": "上挑眉",
			"Standard": "标准眉",
			"one": "一字眉",
			"sagging": "下垂眉"

		}
	},

	"chin": {
		"name": "下巴",
		"chinData": {
			"tip": "尖",
			"party": "方",
			"round": "圆",
			"Ass": "屁股下巴"

		}
	},

	"Eyebrowstyle": {
		"name": "眉毛风格",
		"eyebrowstyleData": {
			"willow": "柳叶眉",
			"wild": "野生眉"
		}


	},

	"eyebrowthickness": {
		"name": "眉毛粗细",
		"eyebrowthicknessData": {
			"cumei": "粗眉",
			"biaozhunmei": "标准眉",
			"xiemei": "细眉"
		}

	},

	"Eyebrowsconcentration": {
		"name": "眉毛浓度",
		"eyebrowsconcentrationData": {
			"piandan": "偏淡",
			"feichandan": "非常淡",
			"nongduzhenghao": "浓密正好"
		}

	},

	"Eyebrowsconcentration_f": {
		"name": "浓度分布",
		"eyebrowsconcentration_fData": {
			"fenbujunyun": "分布均匀",
			"qianshuhoumi": "前疏后密",
			"qianmuhoushu": "前密后疏",
			"lianjunyun": "分布偏均匀"

		}
	},

	"eyespacing": {
		"name": "两眼间距",
		"eyespacingData": {
			"wide": "宽",
			"narrow": "窄",
			"appropriate": "适当"
		}

	},

	"brow": {
		"name": "两眉间距",
		"browData": {
			"wide": "宽",
			"narrow": "窄",
			"appropriate": "适当"
		}

	},

	"lipscurved": {
		"name": "嘴唇弧度",
		"lipscurvedData": {
			"smile": "微笑唇",
			"moderate": "温和唇",
			"attitude": "态度唇"

		}
	},

	"Speciallip": {
		"name": "嘴唇形态",
		"speciallipData": {
			"Cherry_lip": "樱桃唇",
			"Supermodel_lip": "超模唇"
		}

	},

	"face": {
		"name": "脸型",
		"faceData": {
			"baby_face": "娃娃脸",
			"guazilian": "瓜子脸",
			"fanglian": "方脸",
			"edanlian": "鹅蛋脸",
			"changxinglian": "长型脸",
			"lixinglian": "梨形脸",
			"jingzhuan": "晶钻脸"
		}
	}
}
""";

const Map<String, String> EXPLAN = {
  "eyelid_right": "右眼",
  "eyelid_left": "左眼",
  "nose": "鼻翼",
  "eye_shape_right": "右眼风格",
  "eye_shape_left": "左眼风格",
  "wrink": "法令纹",
  "lip_thickness": "嘴唇厚度",
  "lip_peak": "唇峰",
  "cheekbone": "颧骨",
  "brow_shape": "眉毛挑度",
  "brow_density": "浓度分布",
  "pouch": "眼袋",
  "chin_shape": "下巴",
  "eye_distance": "两眼间距",
  "lip_shape": "嘴唇形态",
  "lip_radian": "嘴唇弧度",
  "brows_style": "眉毛风格",
  "brows_thickness": "眉毛粗细",
  "Dense": "眉毛浓度",
  "brows_spacing": "两眉间距",
  "face": "脸型",
};

const List<String> maskTabList = ["左双眼皮", "右双眼皮"];

const Map<String, String> maskExplain = {
  "左双眼皮": "left_eyelid",
  "右双眼皮": "right_eyelid"
};

List<Offset> uiToList(String string) {
  var split = string.split(":");
  List<Offset> list = [];
  for (int i = 0; i < split.length; i += 2) {
    list.add(Offset(
        int.parse(split[i]).toDouble(), int.parse(split[i + 1]).toDouble()));
  }
  return list;
}

String listToUi(List<Offset> list) {
  StringBuffer stringBuffer = new StringBuffer();
  for (int i = 0; i < list.length; i++) {
    stringBuffer.write("${list[i].dx.toInt()}");
    stringBuffer.write(":");
    stringBuffer.write("${list[i].dy.toInt()}");
    if (i != list.length - 1) {
      stringBuffer.write(":");
    }
  }
  return stringBuffer.toString();
}
